/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.token;

import io.trino.hadoop.$internal.org.apache.kerby.asn1.Asn1FieldInfo;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.EnumType;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.ExplicitField;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KrbTokenBase;

/**
 PA-TOKEN-REQUEST ::= SEQUENCE {
    token          [0]  OCTET STRING,
    tokenInfo      [1]  TokenInfo
 }
*/
public class PaTokenRequest extends KrbSequenceType {
    protected enum PaTokenRequestField implements EnumType {
        TOKEN_INFO,
        TOKEN;

        @Override
        public int getValue() {
            return ordinal();
        }

        @Override
        public String getName() {
            return name();
        }
    }

    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[] {
            new ExplicitField(PaTokenRequestField.TOKEN_INFO, TokenInfo.class),
            new ExplicitField(PaTokenRequestField.TOKEN, KrbTokenBase.class)
    };

    public PaTokenRequest() {
        super(fieldInfos);
    }

    public KrbTokenBase getToken() {
        return getFieldAs(PaTokenRequestField.TOKEN, KrbTokenBase.class);
    }

    public void setToken(KrbTokenBase token) {
        setFieldAs(PaTokenRequestField.TOKEN, token);
    }

    public TokenInfo getTokenInfo() {
        return getFieldAs(PaTokenRequestField.TOKEN_INFO, TokenInfo.class);
    }

    public void setTokenInfo(TokenInfo tokenInfo) {
        setFieldAs(PaTokenRequestField.TOKEN_INFO, tokenInfo);
    }
}
