/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package io.trino.hadoop.$internal.org.apache.kerby.x509.type;

import io.trino.hadoop.$internal.org.apache.kerby.asn1.Asn1FieldInfo;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.EnumType;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.ExplicitField;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.type.Asn1SequenceType;

/**
 *Ref. RFC3281
 * <pre>
 * RoleSyntax ::= SEQUENCE {
 *                 roleAuthority  [0] GeneralNames OPTIONAL,
 *                 roleName       [1] GeneralName
 *           } 
 * </pre>
 */
public class RoleSyntax extends Asn1SequenceType {
    protected enum RoleSyntaxField implements EnumType {
        ROLE_AUTHORITY,
        ROLE_NAME;

        @Override
        public int getValue() {
            return ordinal();
        }

        @Override
        public String getName() {
            return name();
        }
    }

    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[] {
        new ExplicitField(RoleSyntaxField.ROLE_AUTHORITY, GeneralNames.class),
        new ExplicitField(RoleSyntaxField.ROLE_NAME, GeneralName.class)
    };

    public RoleSyntax() {
        super(fieldInfos);
    }

    public GeneralNames getRoleAuthority() {
        return getFieldAs(RoleSyntaxField.ROLE_AUTHORITY, GeneralNames.class);
    }

    public void setRoleAuthority(GeneralNames roleAuthority) {
        setFieldAs(RoleSyntaxField.ROLE_AUTHORITY, roleAuthority);
    }

    public GeneralName getRoleName() {
        return getFieldAs(RoleSyntaxField.ROLE_NAME, GeneralName.class);
    }

    public void setRoleName(GeneralName roleName) {
        setFieldAs(RoleSyntaxField.ROLE_NAME, roleName);
    }
}
