package io.trino.hadoop.$internal.org.codehaus.jackson.map.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;

import io.trino.hadoop.$internal.org.codehaus.jackson.JsonGenerationException;
import io.trino.hadoop.$internal.org.codehaus.jackson.JsonGenerator;
import io.trino.hadoop.$internal.org.codehaus.jackson.JsonNode;
import io.trino.hadoop.$internal.org.codehaus.jackson.map.JsonMappingException;
import io.trino.hadoop.$internal.org.codehaus.jackson.map.SerializerProvider;
import io.trino.hadoop.$internal.org.codehaus.jackson.map.ser.std.SerializerBase;

/**
 * Special bogus "serializer" that will throw
 * {@link JsonGenerationException} if its {@link #serialize}
 * gets invoked. Most commonly registered as handler for unknown types,
 * as well as for catching unintended usage (like trying to use null
 * as Map/Object key).
 */
public final class FailingSerializer
    extends SerializerBase<Object>
{
    final String _msg;
    
    public FailingSerializer(String msg) {
        super(Object.class);
        _msg = msg;
    }
    
    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonGenerationException
    {
        throw new JsonGenerationException(_msg);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint)
        throws JsonMappingException
    {
        return null;
    }
}
