/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminContext;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.AdminRequest;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.message.AdminMessageCode;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.message.AdminMessageType;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.message.AdminReq;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.message.KadminCode;
import io.trino.hadoop.$internal.org.apache.kerby.xdr.XdrFieldInfo;
import io.trino.hadoop.$internal.org.apache.kerby.xdr.type.XdrStructType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public abstract class AdminHandler {
    public void init(AdminContext context) {
    }

    public void handleRequest(AdminRequest adminRequest) throws KrbException {
        adminRequest.process();
        AdminReq adminReq = adminRequest.getAdminReq();
        ByteBuffer requestMessage = KadminCode.encodeMessage(adminReq);
        requestMessage.flip();
        try {
            this.sendMessage(adminRequest, requestMessage);
        }
        catch (IOException e) {
            throw new KrbException("Admin sends request message failed", (Throwable)e);
        }
    }

    public void onResponseMessage(AdminRequest adminRequest, ByteBuffer responseMessage) throws KrbException {
        AdminMessageCode decoded = new AdminMessageCode();
        try {
            decoded.decode(responseMessage);
        }
        catch (IOException e) {
            throw new KrbException("On response message failed.", (Throwable)e);
        }
        XdrFieldInfo[] fieldInfos = ((XdrStructType)decoded.getValue()).getXdrFieldInfos();
        AdminMessageType type = (AdminMessageType)fieldInfos[0].getValue();
        switch (type) {
            case ADD_PRINCIPAL_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.ADD_PRINCIPAL_REQ) {
                    System.out.println((String)fieldInfos[2].getValue());
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.ADD_PRINCIPAL_REP);
            }
            case DELETE_PRINCIPAL_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.DELETE_PRINCIPAL_REQ) {
                    System.out.println((String)fieldInfos[2].getValue());
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.DELETE_PRINCIPAL_REP);
            }
            case RENAME_PRINCIPAL_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.RENAME_PRINCIPAL_REQ) {
                    System.out.println((String)fieldInfos[2].getValue());
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.RENAME_PRINCIPAL_REP);
            }
            default: {
                throw new KrbException("Response message type error: " + type);
            }
        }
    }

    public List<String> onResponseMessageForList(AdminRequest adminRequest, ByteBuffer responseMessage) throws KrbException {
        List<String> princalsList = null;
        AdminMessageCode decoded = new AdminMessageCode();
        try {
            decoded.decode(responseMessage);
        }
        catch (IOException e) {
            throw new KrbException("On response message failed.", (Throwable)e);
        }
        XdrFieldInfo[] fieldInfos = ((XdrStructType)decoded.getValue()).getXdrFieldInfos();
        AdminMessageType type = (AdminMessageType)fieldInfos[0].getValue();
        switch (type) {
            case GET_PRINCS_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.GET_PRINCS_REQ) {
                    String[] temp = ((String)fieldInfos[2].getValue()).trim().split(" ");
                    princalsList = Arrays.asList(temp);
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.GET_PRINCS_REP);
            }
            default: {
                throw new KrbException("Response message type error: " + type);
            }
        }
        return princalsList;
    }

    protected abstract void sendMessage(AdminRequest var1, ByteBuffer var2) throws IOException;

    protected abstract List<String> handleRequestForList(AdminRequest var1) throws KrbException;
}

