/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

@InterfaceAudience.Private
public class FileWithSnapshotFeature
implements INode.Feature {
    private final FileDiffList diffs;
    private boolean isCurrentFileDeleted = false;

    public FileWithSnapshotFeature(FileDiffList diffs) {
        this.diffs = diffs != null ? diffs : new FileDiffList();
    }

    public boolean isCurrentFileDeleted() {
        return this.isCurrentFileDeleted;
    }

    public void deleteCurrentFile() {
        this.isCurrentFileDeleted = true;
    }

    public FileDiffList getDiffs() {
        return this.diffs;
    }

    public short getMaxBlockRepInDiffs(FileDiff excluded) {
        short max = 0;
        for (FileDiff d : this.getDiffs()) {
            short replication;
            if (d == excluded || d.snapshotINode == null || (replication = ((INodeFileAttributes)d.snapshotINode).getFileReplication()) <= max) continue;
            max = replication;
        }
        return max;
    }

    boolean changedBetweenSnapshots(INodeFile file, Snapshot from, Snapshot to) {
        long laterLength;
        int[] diffIndexPair = this.diffs.changedBetweenSnapshots(from, to);
        if (diffIndexPair == null) {
            return false;
        }
        int earlierDiffIndex = diffIndexPair[0];
        int laterDiffIndex = diffIndexPair[1];
        DiffList diffList = this.diffs.asList();
        long earlierLength = ((FileDiff)diffList.get(earlierDiffIndex)).getFileSize();
        long l = laterLength = laterDiffIndex == diffList.size() ? file.computeFileSize(true, false) : ((FileDiff)diffList.get(laterDiffIndex)).getFileSize();
        if (earlierLength != laterLength) {
            return true;
        }
        INodeFileAttributes earlierAttr = null;
        for (int i = earlierDiffIndex; i < laterDiffIndex; ++i) {
            FileDiff diff = (FileDiff)diffList.get(i);
            if (diff.snapshotINode == null) continue;
            earlierAttr = (INodeFileAttributes)diff.snapshotINode;
            break;
        }
        if (earlierAttr == null) {
            return false;
        }
        INodeFileAttributes laterAttr = this.diffs.getSnapshotINode(Math.max(Snapshot.getSnapshotId(from), Snapshot.getSnapshotId(to)), file);
        return !earlierAttr.metadataEquals(laterAttr);
    }

    public String getDetailedString() {
        return (this.isCurrentFileDeleted() ? "(DELETED), " : ", ") + this.diffs;
    }

    public void cleanFile(INode.ReclaimContext reclaimContext, INodeFile file, int snapshotId, int priorSnapshotId, byte storagePolicyId) {
        if (snapshotId == 0x7FFFFFFE) {
            if (!this.isCurrentFileDeleted()) {
                file.recordModification(priorSnapshotId);
                this.deleteCurrentFile();
            }
            BlockStoragePolicy policy = reclaimContext.storagePolicySuite().getPolicy(storagePolicyId);
            QuotaCounts old = file.storagespaceConsumed(policy);
            this.collectBlocksAndClear(reclaimContext, file);
            QuotaCounts current = file.storagespaceConsumed(policy);
            reclaimContext.quotaDelta().add(old.subtract(current));
        } else {
            priorSnapshotId = this.getDiffs().updatePrior(snapshotId, priorSnapshotId);
            this.diffs.deleteSnapshotDiff(reclaimContext, snapshotId, priorSnapshotId, file);
        }
    }

    public void clearDiffs() {
        this.diffs.clear();
    }

    public void updateQuotaAndCollectBlocks(INode.ReclaimContext reclaimContext, INodeFile file, FileDiff removed) {
        QuotaCounts oldCounts;
        byte storagePolicyID = file.getStoragePolicyID();
        BlockStoragePolicy bsp = null;
        if (storagePolicyID != 0) {
            bsp = reclaimContext.storagePolicySuite().getPolicy(file.getStoragePolicyID());
        }
        if (removed.snapshotINode != null) {
            BlockInfo[] blocks;
            oldCounts = new QuotaCounts.Builder().build();
            for (BlockInfo b : blocks = file.getBlocks() == null ? new BlockInfo[]{} : file.getBlocks()) {
                short replication = b.getReplication();
                long blockSize = b.isComplete() ? b.getNumBytes() : file.getPreferredBlockSize();
                oldCounts.addStorageSpace(blockSize * (long)replication);
                if (bsp == null) continue;
                List<StorageType> oldTypeChosen = bsp.chooseStorageTypes(replication);
                for (StorageType t : oldTypeChosen) {
                    if (!t.supportTypeQuota()) continue;
                    oldCounts.addTypeSpace(t, blockSize);
                }
            }
            AclFeature aclFeature = ((INodeFileAttributes)removed.getSnapshotINode()).getAclFeature();
            if (aclFeature != null) {
                AclStorage.removeAclFeature(aclFeature);
            }
        } else {
            oldCounts = file.storagespaceConsumed(null);
        }
        this.getDiffs().combineAndCollectSnapshotBlocks(reclaimContext, file, removed);
        if (file.getBlocks() != null) {
            short replInDiff = this.getMaxBlockRepInDiffs(removed);
            short repl = (short)Math.max(file.getPreferredBlockReplication(), replInDiff);
            for (BlockInfo b : file.getBlocks()) {
                if (repl == b.getReplication()) continue;
                reclaimContext.collectedBlocks().addUpdateReplicationFactor(b, repl);
            }
        }
        QuotaCounts current = file.storagespaceConsumed(bsp);
        reclaimContext.quotaDelta().add(oldCounts.subtract(current));
    }

    public void collectBlocksAndClear(INode.ReclaimContext reclaimContext, INodeFile file) {
        BlockInfo[] snapshotBlocks;
        if (this.isCurrentFileDeleted() && this.getDiffs().asList().isEmpty()) {
            file.clearFile(reclaimContext);
            return;
        }
        FileDiff diff = (FileDiff)this.getDiffs().getLast();
        long max = this.isCurrentFileDeleted() ? (diff == null ? 0L : diff.getFileSize()) : file.computeFileSize();
        FileDiff last = (FileDiff)this.diffs.getLast();
        BlockInfo[] blockInfoArray = snapshotBlocks = last == null ? null : last.getBlocks();
        if (snapshotBlocks == null) {
            file.collectBlocksBeyondMax(max, reclaimContext.collectedBlocks(), null);
        } else {
            file.collectBlocksBeyondSnapshot(snapshotBlocks, reclaimContext.collectedBlocks());
        }
    }
}

