/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.datalake.store;

import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ADLException;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ADLStoreClient;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ContentSummary;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.Core;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.DirectoryEntry;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.DirectoryEntryType;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.OperationResponse;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ProcessingQueue;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.RequestOptions;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.UserGroupRepresentation;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies.ExponentialBackoffPolicy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

class ContentSummaryProcessor {
    private AtomicLong fileCount = new AtomicLong(0L);
    private AtomicLong directoryCount = new AtomicLong(0L);
    private AtomicLong totalBytes = new AtomicLong(0L);
    private ProcessingQueue<DirectoryEntry> queue = new ProcessingQueue();
    private ADLStoreClient client;
    private static final int NUM_THREADS = 16;
    private static final int ENUMERATION_PAGESIZE = 16000;

    ContentSummaryProcessor() {
    }

    public ContentSummary getContentSummary(ADLStoreClient client, String dirname) throws IOException {
        this.client = client;
        DirectoryEntry de = client.getDirectoryEntry(dirname);
        if (de.type == DirectoryEntryType.FILE) {
            this.processFile(de);
        } else {
            this.queue.add(de);
            this.processDirectory(de);
            Thread[] threads = new Thread[16];
            for (int i = 0; i < 16; ++i) {
                threads[i] = new Thread(new ThreadProcessor());
                threads[i].start();
            }
            for (Thread t : threads) {
                try {
                    t.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return new ContentSummary(this.totalBytes.get(), this.directoryCount.get(), this.fileCount.get(), this.totalBytes.get());
    }

    private void processDirectoryTree(String directoryName) throws IOException {
        ArrayList list;
        int pagesize = 16000;
        boolean eol = false;
        String startAfter = null;
        while ((list = (ArrayList)this.enumerateDirectoryInternal(directoryName, pagesize, startAfter, null, null)) != null && list.size() != 0) {
            for (DirectoryEntry de : list) {
                if (de.type == DirectoryEntryType.DIRECTORY) {
                    this.queue.add(de);
                    this.processDirectory(de);
                }
                if (de.type == DirectoryEntryType.FILE) {
                    this.processFile(de);
                }
                startAfter = de.name;
            }
            if (list.size() >= pagesize) continue;
        }
    }

    private void processDirectory(DirectoryEntry de) {
        this.directoryCount.incrementAndGet();
    }

    private void processFile(DirectoryEntry de) {
        this.fileCount.incrementAndGet();
        this.totalBytes.addAndGet(de.length);
    }

    private List<DirectoryEntry> enumerateDirectoryInternal(String path, int maxEntriesToRetrieve, String startAfter, String endBefore, UserGroupRepresentation oidOrUpn) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        List<DirectoryEntry> dirEnt = Core.listStatus(path, startAfter, endBefore, maxEntriesToRetrieve, oidOrUpn, this.client, opts, resp);
        if (!resp.successful) {
            throw this.client.getExceptionFromResponse(resp, "Error enumerating directory " + path);
        }
        return dirEnt;
    }

    private class ThreadProcessor
    implements Runnable {
        private ThreadProcessor() {
        }

        @Override
        public void run() {
            try {
                DirectoryEntry de;
                while ((de = (DirectoryEntry)ContentSummaryProcessor.this.queue.poll()) != null) {
                    try {
                        if (de.type != DirectoryEntryType.DIRECTORY) continue;
                        ContentSummaryProcessor.this.processDirectoryTree(de.fullName);
                    }
                    catch (ADLException ex) {
                        if (ex.httpResponseCode == 404) continue;
                        throw ex;
                    }
                    finally {
                        ContentSummaryProcessor.this.queue.unregister();
                    }
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("IOException processing Directory tree", ex);
            }
        }
    }
}

