/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.datalake.store;

import io.trino.hadoop.$internal.com.fasterxml.jackson.core.JsonFactory;
import io.trino.hadoop.$internal.com.fasterxml.jackson.core.JsonParser;
import io.trino.hadoop.$internal.com.fasterxml.jackson.core.JsonToken;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ADLStoreClient;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.LatencyTracker;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.Operation;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.OperationResponse;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.QueryParams;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.RequestOptions;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies.NonIdempotentRetryPolicy;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;

public class HttpTransport {
    private static final String API_VERSION = "2017-08-01";
    private static final Logger log = LoggerFactory.getLogger("io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.HttpTransport");
    private static final Logger tokenlog = LoggerFactory.getLogger("io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.HttpTransport.tokens");
    private static Proxy proxy = Proxy.NO_PROXY;

    public static void setConnectionProxy(Proxy proxy) {
        HttpTransport.proxy = Objects.requireNonNull(proxy, "proxy is null");
    }

    static void makeCall(ADLStoreClient client, Operation op, String path, QueryParams queryParams, byte[] requestBody, int offsetWithinContentsArray, int length, RequestOptions opts, OperationResponse resp) {
        if (opts == null) {
            throw new IllegalArgumentException("RequestOptions parameter missing from call");
        }
        if (resp == null) {
            throw new IllegalArgumentException("OperationResponse parameter missing from call");
        }
        if (opts.retryPolicy == null) {
            opts.retryPolicy = new NonIdempotentRetryPolicy();
        }
        String clientRequestId = opts.requestid == null ? UUID.randomUUID().toString() : opts.requestid;
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        queryParams.setOp(op);
        queryParams.setApiVersion(API_VERSION);
        int retryCount = 0;
        do {
            opts.requestid = clientRequestId + "." + Integer.toString(retryCount);
            resp.reset();
            long start = System.nanoTime();
            HttpTransport.makeSingleCall(client, op, path, queryParams, requestBody, offsetWithinContentsArray, length, opts, resp);
            resp.lastCallLatency = System.nanoTime() - start;
            resp.lastCallLatency /= 1000000L;
            resp.numRetries = retryCount;
            String respLength = resp.responseChunked ? "chunked" : Long.toString(resp.responseContentLength);
            String error = "";
            String outcome = null;
            if (HttpTransport.isSuccessfulResponse(resp, op)) {
                resp.successful = true;
                outcome = "Succeeded";
                LatencyTracker.addLatency(opts.requestid, retryCount, resp.lastCallLatency, op.name, (long)length + resp.responseContentLength, client.getClientId());
            } else {
                resp.successful = false;
                outcome = "Failed";
                error = resp.ex != null ? resp.ex.getClass().getName() : "HTTP" + resp.httpResponseCode + "(" + resp.remoteExceptionName + ")";
                LatencyTracker.addError(opts.requestid, retryCount, resp.lastCallLatency, error, op.name, length, client.getClientId());
                ++retryCount;
                String string = resp.exceptionHistory = resp.exceptionHistory == null ? error : resp.exceptionHistory + "," + error;
            }
            if (!log.isDebugEnabled()) continue;
            String logline = "HTTPRequest," + outcome + ",cReqId:" + opts.requestid + ",lat:" + Long.toString(resp.lastCallLatency) + ",err:" + error + ",Reqlen:" + length + ",Resplen:" + respLength + ",token_ns:" + Long.toString(resp.tokenAcquisitionLatency) + ",sReqId:" + resp.requestId + ",path:" + path + ",qp:" + queryParams.serialize();
            log.debug(logline);
        } while (!resp.successful && opts.retryPolicy.shouldRetry(resp.httpResponseCode, resp.ex));
    }

    private static boolean isSuccessfulResponse(OperationResponse resp, Operation op) {
        if (resp.ex != null) {
            return false;
        }
        if (!resp.successful) {
            return false;
        }
        return resp.httpResponseCode >= 100 && resp.httpResponseCode < 300;
    }

    private static void makeSingleCall(ADLStoreClient client, Operation op, String path, QueryParams queryParams, byte[] requestBody, int offsetWithinContentsArray, int length, RequestOptions opts, OperationResponse resp) {
        block33: {
            URL url;
            if (client == null) {
                throw new IllegalArgumentException("client is null");
            }
            if (client.getAccountName() == null || client.getAccountName().equals("")) {
                resp.successful = false;
                resp.message = "Account name or client is null or blank";
                return;
            }
            String token = null;
            long tokenStartTime = System.nanoTime();
            try {
                token = client.getAccessToken();
                if (token == null || token.equals("")) {
                    resp.successful = false;
                    resp.message = "Access token is null or blank";
                    resp.tokenAcquisitionLatency = System.nanoTime() - tokenStartTime;
                    return;
                }
            }
            catch (IOException ex) {
                resp.successful = false;
                resp.message = "Error fetching access token";
                resp.ex = ex;
                resp.tokenAcquisitionLatency = System.nanoTime() - tokenStartTime;
                return;
            }
            resp.tokenAcquisitionLatency = System.nanoTime() - tokenStartTime;
            if (op == null) {
                resp.successful = false;
                resp.message = "operation is null";
                return;
            }
            if (path == null || path.trim().equals("")) {
                resp.successful = false;
                resp.message = "path is null";
                return;
            }
            resp.opCode = op.name;
            if (requestBody != null && requestBody.length > 0) {
                if (offsetWithinContentsArray < 0 || length < 0 || offsetWithinContentsArray + length < 0 || offsetWithinContentsArray >= requestBody.length || offsetWithinContentsArray + length > requestBody.length) {
                    throw new IndexOutOfBoundsException("offset+length overflows byte buffer for path " + path);
                }
            } else if (offsetWithinContentsArray != 0 || length != 0) {
                throw new IndexOutOfBoundsException("Non-zero offset or length with null body for path " + path);
            }
            StringBuilder urlString = new StringBuilder();
            urlString.append(client.getHttpPrefix());
            urlString.append("://");
            urlString.append(client.getAccountName());
            urlString.append(op.namespace);
            String prefix = client.getFilePathPrefix();
            if (prefix != null) {
                urlString.append(prefix);
            }
            if (path.charAt(0) != '/') {
                urlString.append('/');
            }
            try {
                urlString.append(new URI(null, null, path, null).toASCIIString());
            }
            catch (URISyntaxException ex) {
                resp.successful = false;
                resp.message = "Invalid path " + path;
                return;
            }
            urlString.append('?');
            urlString.append(queryParams.serialize());
            try {
                url = new URL(urlString.toString());
            }
            catch (MalformedURLException ex) {
                resp.ex = ex;
                resp.successful = false;
                return;
            }
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection(proxy);
                conn.setRequestProperty("Authorization", token);
                conn.setRequestProperty("User-Agent", client.getUserAgent());
                conn.setRequestProperty("x-ms-client-request-id", opts.requestid);
                String latencyHeader = LatencyTracker.get();
                if (latencyHeader != null) {
                    conn.setRequestProperty("x-ms-adl-client-latency", latencyHeader);
                }
                if (client.getTiHeaderValue() != null) {
                    conn.setRequestProperty("x-ms-tracking-info", client.getTiHeaderValue());
                }
                conn.setConnectTimeout(opts.timeout);
                conn.setReadTimeout(opts.timeout);
                conn.setUseCaches(false);
                conn.setRequestMethod(op.method);
                conn.setDoInput(true);
                if (!op.method.equals("GET")) {
                    conn.setDoOutput(true);
                    conn.setRequestMethod(op.method);
                    OutputStream outStr = conn.getOutputStream();
                    if (op.requiresBody && requestBody != null) {
                        outStr.write(requestBody, offsetWithinContentsArray, length);
                        outStr.close();
                    } else {
                        byte[] buf = new byte[]{};
                        outStr.write(buf);
                        outStr.close();
                    }
                }
                resp.httpResponseCode = conn.getResponseCode();
                resp.httpResponseMessage = conn.getResponseMessage();
                resp.requestId = conn.getHeaderField("x-ms-request-id");
                resp.responseContentLength = conn.getHeaderFieldLong("Content-Length", 0L);
                String chunked = conn.getHeaderField("Transfer-Encoding");
                if (chunked != null && chunked.equals("chunked")) {
                    resp.responseChunked = true;
                }
                if (resp.httpResponseCode >= 400) {
                    if (resp.httpResponseCode == 401 && tokenlog.isDebugEnabled()) {
                        String logline = "HTTPRequest,HTTP401,cReqId:" + opts.requestid + ",sReqId:" + resp.requestId + ",path:" + path + ",token:" + token;
                        tokenlog.debug(logline);
                    }
                    if (resp.responseContentLength > 0L && conn.getErrorStream() != null) {
                        HttpTransport.getCodesFromJSon(conn.getErrorStream(), resp);
                        return;
                    }
                } else {
                    HttpTransport.consumeInputStream(conn.getErrorStream());
                    if (op.returnsBody) {
                        resp.responseStream = conn.getInputStream();
                    } else {
                        HttpTransport.consumeInputStream(conn.getInputStream());
                    }
                }
            }
            catch (IOException ex) {
                resp.ex = ex;
                resp.successful = false;
                if (conn == null) break block33;
                try {
                    HttpTransport.consumeInputStream(conn.getInputStream());
                    HttpTransport.consumeInputStream(conn.getErrorStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static void consumeInputStream(InputStream istr) throws IOException {
        if (istr != null) {
            try {
                byte[] b = new byte[65536];
                while (istr.read(b) >= 0) {
                }
            }
            finally {
                istr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getCodesFromJSon(InputStream s, OperationResponse resp) {
        try {
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createParser(s);
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            while (jp.hasCurrentToken()) {
                if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = jp.getCurrentName();
                    jp.nextToken();
                    String fieldValue = jp.getText();
                    if (fieldName.equals("exception")) {
                        resp.remoteExceptionName = fieldValue;
                    }
                    if (fieldName.equals("message")) {
                        resp.remoteExceptionMessage = fieldValue;
                    }
                    if (fieldName.equals("javaClassName")) {
                        resp.remoteExceptionJavaClassName = fieldValue;
                    }
                }
                jp.nextToken();
            }
            jp.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }
}

