/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.util.regex.Pattern;

public class NameValidator {
    private static final int BLOB_FILE_DIRECTORY_MIN_LENGTH = 1;
    private static final int CONTAINER_SHARE_QUEUE_TABLE_MIN_LENGTH = 3;
    private static final int CONTAINER_SHARE_QUEUE_TABLE_MAX_LENGTH = 63;
    private static final int FILE_DIRECTORY_MAX_LENGTH = 255;
    private static final int BLOB_MAX_LENGTH = 1024;
    private static final Pattern FILE_DIRECTORY_REGEX = Pattern.compile("^[^\"\\/:|<>*?]*/{0,1}");
    private static final Pattern SHARE_CONTAINER_QUEUE_REGEX = Pattern.compile("^[a-z0-9]+(-[a-z0-9]+)*$");
    private static final Pattern TABLE_REGEX = Pattern.compile("^[A-Za-z][A-Za-z0-9]*$");
    private static final Pattern METRICS_TABLE_REGEX = Pattern.compile("^\\$Metrics(HourPrimary|MinutePrimary|HourSecondary|MinuteSecondary)?(Transactions)(Blob|Queue|Table)$");
    private static final String[] RESERVED_FILE_NAMES = new String[]{".", "..", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "PRN", "AUX", "NUL", "CON", "CLOCK$"};

    public static void validateContainerName(String containerName) {
        if (!"$root".equals(containerName) && !"$logs".equals(containerName)) {
            NameValidator.validateShareContainerQueueHelper(containerName, "container");
        }
    }

    public static void validateQueueName(String queueName) {
        NameValidator.validateShareContainerQueueHelper(queueName, "queue");
    }

    public static void validateShareName(String shareName) {
        NameValidator.validateShareContainerQueueHelper(shareName, "share");
    }

    private static void validateShareContainerQueueHelper(String resourceName, String resourceType) {
        if (Utility.isNullOrEmptyOrWhitespace(resourceName)) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name. The name may not be null, empty, or whitespace only.", resourceType));
        }
        if (resourceName.length() < 3 || resourceName.length() > 63) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name length. The name must be between %s and %s characters long.", resourceType, 3, 63));
        }
        if (!SHARE_CONTAINER_QUEUE_REGEX.matcher(resourceName).matches()) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name. Check MSDN for more information about valid naming.", resourceType));
        }
    }

    public static void validateBlobName(String blobName) {
        if (Utility.isNullOrEmptyOrWhitespace(blobName)) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name. The name may not be null, empty, or whitespace only.", "blob"));
        }
        if (blobName.length() < 1 || blobName.length() > 1024) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name length. The name must be between %s and %s characters long.", "blob", 1, 1024));
        }
        int slashCount = 0;
        for (int i = 0; i < blobName.length(); ++i) {
            if (blobName.charAt(i) != '/') continue;
            ++slashCount;
        }
        if (slashCount >= 254) {
            throw new IllegalArgumentException("The count of URL path segments (strings between '/' characters) as part of the blob name cannot exceed 254.");
        }
    }

    public static void validateFileName(String fileName) {
        NameValidator.ValidateFileDirectoryHelper(fileName, "file");
        if (fileName.endsWith("/")) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name. Check MSDN for more information about valid naming.", "file"));
        }
        for (String s : RESERVED_FILE_NAMES) {
            if (!s.equalsIgnoreCase(fileName)) continue;
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name. This name is reserved.", "file"));
        }
    }

    public static void validateDirectoryName(String directoryName) {
        NameValidator.ValidateFileDirectoryHelper(directoryName, "directory");
    }

    private static void ValidateFileDirectoryHelper(String resourceName, String resourceType) {
        if (Utility.isNullOrEmptyOrWhitespace(resourceName)) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name. The name may not be null, empty, or whitespace only.", resourceType));
        }
        if (resourceName.length() < 1 || resourceName.length() > 255) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name length. The name must be between %s and %s characters long.", resourceType, 1, 255));
        }
        if (!FILE_DIRECTORY_REGEX.matcher(resourceName).matches()) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name. Check MSDN for more information about valid naming.", resourceType));
        }
    }

    public static void validateTableName(String tableName) {
        if (Utility.isNullOrEmptyOrWhitespace(tableName)) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name. The name may not be null, empty, or whitespace only.", "table"));
        }
        if (tableName.length() < 3 || tableName.length() > 63) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name length. The name must be between %s and %s characters long.", "table", 3, 63));
        }
        if (!(TABLE_REGEX.matcher(tableName).matches() || METRICS_TABLE_REGEX.matcher(tableName).matches() || tableName.equalsIgnoreCase("$MetricsCapacityBlob"))) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Invalid %s name. Check MSDN for more information about valid naming.", "table"));
        }
    }
}

