/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.io.netty.handler.codec.http;

import io.trino.hadoop.$internal.io.netty.handler.codec.http.DefaultHttpMessage;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpMessageUtil;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpMethod;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpRequest;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpVersion;

public class DefaultHttpRequest
extends DefaultHttpMessage
implements HttpRequest {
    private HttpMethod method;
    private String uri;

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri) {
        this(httpVersion, method, uri, true);
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, boolean validateHeaders) {
        super(httpVersion, validateHeaders);
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.method = method;
        this.uri = uri;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public HttpRequest setMethod(HttpMethod method) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        this.method = method;
        return this;
    }

    @Override
    public HttpRequest setUri(String uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.uri = uri;
        return this;
    }

    @Override
    public HttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    public String toString() {
        return HttpMessageUtil.appendRequest(new StringBuilder(256), this).toString();
    }
}

