/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;

public class AbfsRestOperation {
    private final AbfsRestOperationType operationType;
    private final AbfsClient client;
    private final String method;
    private final URL url;
    private final List<AbfsHttpHeader> requestHeaders;
    private final boolean hasRequestBody;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsClient.class);
    private byte[] buffer;
    private int bufferOffset;
    private int bufferLength;
    private AbfsHttpOperation result;

    public AbfsHttpOperation getResult() {
        return this.result;
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders) {
        this.operationType = operationType;
        this.client = client;
        this.method = method;
        this.url = url;
        this.requestHeaders = requestHeaders;
        this.hasRequestBody = "PUT".equals(method) || "PATCH".equals(method);
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders, byte[] buffer, int bufferOffset, int bufferLength) {
        this(operationType, client, method, url, requestHeaders);
        this.buffer = buffer;
        this.bufferOffset = bufferOffset;
        this.bufferLength = bufferLength;
    }

    void execute() throws AzureBlobFileSystemException {
        int retryCount = 0;
        while (!this.executeHttpOperation(retryCount++)) {
            try {
                Thread.sleep(this.client.getRetryPolicy().getRetryInterval(retryCount));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.result.getStatusCode() >= 400) {
            throw new AbfsRestOperationException(this.result.getStatusCode(), this.result.getStorageErrorCode(), this.result.getStorageErrorMessage(), null, this.result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeHttpOperation(int retryCount) throws AzureBlobFileSystemException {
        AbfsHttpOperation httpOperation = null;
        try {
            httpOperation = new AbfsHttpOperation(this.url, this.method, this.requestHeaders);
            if (this.client.getAccessToken() == null) {
                this.client.getSharedKeyCredentials().signRequest(httpOperation.getConnection(), this.hasRequestBody ? (long)this.bufferLength : 0L);
            } else {
                httpOperation.getConnection().setRequestProperty("Authorization", this.client.getAccessToken());
            }
            AbfsClientThrottlingIntercept.sendingRequest(this.operationType);
            if (this.hasRequestBody) {
                httpOperation.sendRequest(this.buffer, this.bufferOffset, this.bufferLength);
            }
            httpOperation.processResponse(this.buffer, this.bufferOffset, this.bufferLength);
        }
        catch (IOException ex) {
            boolean bl;
            try {
                if (LOG.isDebugEnabled()) {
                    if (httpOperation != null) {
                        LOG.debug("HttpRequestFailure: " + httpOperation.toString(), ex);
                    } else {
                        LOG.debug("HttpRequestFailure: " + this.method + "," + this.url, ex);
                    }
                }
                if (!this.client.getRetryPolicy().shouldRetry(retryCount, -1)) {
                    throw new InvalidAbfsRestOperationException(ex);
                }
                if (ex instanceof AzureADAuthenticator.HttpException) {
                    throw new AbfsRestOperationException((AzureADAuthenticator.HttpException)ex);
                }
                bl = false;
            }
            catch (Throwable throwable) {
                AbfsClientThrottlingIntercept.updateMetrics(this.operationType, httpOperation);
                throw throwable;
            }
            AbfsClientThrottlingIntercept.updateMetrics(this.operationType, httpOperation);
            return bl;
        }
        AbfsClientThrottlingIntercept.updateMetrics(this.operationType, httpOperation);
        LOG.debug("HttpRequest: " + httpOperation.toString());
        if (this.client.getRetryPolicy().shouldRetry(retryCount, httpOperation.getStatusCode())) {
            return false;
        }
        this.result = httpOperation;
        return true;
    }
}

