/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import io.trino.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.apache.hadoop.hdfs.web.resources.StringParam;
import org.apache.hadoop.security.UserGroupInformation;

public class UserParam
extends StringParam {
    public static final String NAME = "user.name";
    public static final String DEFAULT = "";
    private static StringParam.Domain domain = new StringParam.Domain("user.name", Pattern.compile("^[A-Za-z_][A-Za-z0-9._-]*[$]?$"));

    @VisibleForTesting
    public static StringParam.Domain getUserPatternDomain() {
        return domain;
    }

    @VisibleForTesting
    public static void setUserPatternDomain(StringParam.Domain dm) {
        domain = dm;
    }

    public static void setUserPattern(String pattern) {
        domain = new StringParam.Domain(NAME, Pattern.compile(pattern));
    }

    private static String validateLength(String str) {
        if (str == null) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter [{0}], cannot be NULL", NAME));
        }
        int len = str.length();
        if (len < 1) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter [{0}], it's length must be at least 1", NAME));
        }
        return str;
    }

    public UserParam(String str) {
        super(domain, str == null || str.equals(DEFAULT) ? null : UserParam.validateLength(str));
    }

    public UserParam(UserGroupInformation ugi) {
        this(ugi.getShortUserName());
    }

    @Override
    public String getName() {
        return NAME;
    }
}

