/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.org.apache.commons.lang3.NotImplementedException;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.lang.ref.WeakReference;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallQueueManager;
import org.apache.hadoop.ipc.FairCallQueueMXBean;
import org.apache.hadoop.ipc.RpcMultiplexer;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.WeightedRoundRobinMultiplexer;
import org.apache.hadoop.metrics2.util.MBeans;

public class FairCallQueue<E extends Schedulable>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    @Deprecated
    public static final int IPC_CALLQUEUE_PRIORITY_LEVELS_DEFAULT = 4;
    @Deprecated
    public static final String IPC_CALLQUEUE_PRIORITY_LEVELS_KEY = "faircallqueue.priority-levels";
    public static final Logger LOG = LoggerFactory.getLogger(FairCallQueue.class);
    private final ArrayList<BlockingQueue<E>> queues;
    private final Semaphore semaphore = new Semaphore(0);
    private RpcMultiplexer multiplexer;
    private final ArrayList<AtomicLong> overflowedCalls;

    private void signalNotEmpty() {
        this.semaphore.release();
    }

    public FairCallQueue(int priorityLevels, int capacity, String ns, Configuration conf) {
        if (priorityLevels < 1) {
            throw new IllegalArgumentException("Number of Priority Levels must be at least 1");
        }
        int numQueues = priorityLevels;
        LOG.info("FairCallQueue is in use with " + numQueues + " queues with total capacity of " + capacity);
        this.queues = new ArrayList(numQueues);
        this.overflowedCalls = new ArrayList(numQueues);
        int queueCapacity = capacity / numQueues;
        int capacityForFirstQueue = queueCapacity + capacity % numQueues;
        for (int i = 0; i < numQueues; ++i) {
            if (i == 0) {
                this.queues.add(new LinkedBlockingQueue(capacityForFirstQueue));
            } else {
                this.queues.add(new LinkedBlockingQueue(queueCapacity));
            }
            this.overflowedCalls.add(new AtomicLong(0L));
        }
        this.multiplexer = new WeightedRoundRobinMultiplexer(numQueues, ns, conf);
        MetricsProxy mp = MetricsProxy.getInstance(ns);
        mp.setDelegate(this);
    }

    private E removeNextElement() {
        int priority = this.multiplexer.getAndAdvanceCurrentIndex();
        Schedulable e = (Schedulable)this.queues.get(priority).poll();
        while (e == null) {
            for (int idx = 0; e == null && idx < this.queues.size(); ++idx) {
                e = (Schedulable)this.queues.get(idx).poll();
            }
        }
        return (E)e;
    }

    @Override
    public boolean add(E e) {
        int priorityLevel = e.getPriorityLevel();
        if (!this.offerQueues(priorityLevel, e, true)) {
            throw priorityLevel == this.queues.size() - 1 ? CallQueueManager.CallQueueOverflowException.DISCONNECT : CallQueueManager.CallQueueOverflowException.KEEPALIVE;
        }
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        int priorityLevel = e.getPriorityLevel();
        if (!this.offerQueues(priorityLevel, e, false)) {
            this.putQueue(this.queues.size() - 1, e);
        }
    }

    @.VisibleForTesting
    void putQueue(int priority, E e) throws InterruptedException {
        this.queues.get(priority).put(e);
        this.signalNotEmpty();
    }

    @.VisibleForTesting
    boolean offerQueue(int priority, E e) {
        boolean ret = this.queues.get(priority).offer(e);
        if (ret) {
            this.signalNotEmpty();
        }
        return ret;
    }

    private boolean offerQueues(int priority, E e, boolean includeLast) {
        int lastPriority = this.queues.size() - (includeLast ? 1 : 2);
        for (int i = priority; i <= lastPriority; ++i) {
            if (this.offerQueue(i, e)) {
                return true;
            }
            this.overflowedCalls.get(i).getAndIncrement();
        }
        return false;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        int priorityLevel = e.getPriorityLevel();
        BlockingQueue<E> q = this.queues.get(priorityLevel);
        boolean ret = q.offer(e, timeout, unit);
        if (ret) {
            this.signalNotEmpty();
        }
        return ret;
    }

    @Override
    public boolean offer(E e) {
        int priorityLevel = e.getPriorityLevel();
        BlockingQueue<E> q = this.queues.get(priorityLevel);
        boolean ret = q.offer(e);
        if (ret) {
            this.signalNotEmpty();
        }
        return ret;
    }

    @Override
    public E take() throws InterruptedException {
        this.semaphore.acquire();
        return this.removeNextElement();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.semaphore.tryAcquire(timeout, unit) ? (E)this.removeNextElement() : null;
    }

    @Override
    public E poll() {
        return this.semaphore.tryAcquire() ? (E)this.removeNextElement() : null;
    }

    @Override
    public E peek() {
        Schedulable e = null;
        for (int i = 0; e == null && i < this.queues.size(); ++i) {
            e = (Schedulable)this.queues.get(i).peek();
        }
        return (E)e;
    }

    @Override
    public int size() {
        return this.semaphore.availablePermits();
    }

    @Override
    public Iterator<E> iterator() {
        throw new NotImplementedException("Code is not implemented");
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int numElements;
        int permits = this.semaphore.drainPermits();
        int numRemaining = numElements = Math.min(maxElements, permits);
        for (int i = 0; numRemaining > 0 && i < this.queues.size(); numRemaining -= this.queues.get(i).drainTo(c, numRemaining), ++i) {
        }
        int drained = numElements - numRemaining;
        if (permits > drained) {
            this.semaphore.release(permits - drained);
        }
        return drained;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int remainingCapacity() {
        int sum = 0;
        for (BlockingQueue<E> q : this.queues) {
            sum += q.remainingCapacity();
        }
        return sum;
    }

    public int[] getQueueSizes() {
        int numQueues = this.queues.size();
        int[] sizes = new int[numQueues];
        for (int i = 0; i < numQueues; ++i) {
            sizes[i] = this.queues.get(i).size();
        }
        return sizes;
    }

    public long[] getOverflowedCalls() {
        int numQueues = this.queues.size();
        long[] calls = new long[numQueues];
        for (int i = 0; i < numQueues; ++i) {
            calls[i] = this.overflowedCalls.get(i).get();
        }
        return calls;
    }

    @.VisibleForTesting
    public void setMultiplexer(RpcMultiplexer newMux) {
        this.multiplexer = newMux;
    }

    private static final class MetricsProxy
    implements FairCallQueueMXBean {
        private static final HashMap<String, MetricsProxy> INSTANCES = new HashMap();
        private WeakReference<FairCallQueue<? extends Schedulable>> delegate;
        private int revisionNumber = 0;

        private MetricsProxy(String namespace) {
            MBeans.register(namespace, "FairCallQueue", this);
        }

        public static synchronized MetricsProxy getInstance(String namespace) {
            MetricsProxy mp = INSTANCES.get(namespace);
            if (mp == null) {
                mp = new MetricsProxy(namespace);
                INSTANCES.put(namespace, mp);
            }
            return mp;
        }

        public void setDelegate(FairCallQueue<? extends Schedulable> obj) {
            this.delegate = new WeakReference<FairCallQueue<? extends Schedulable>>(obj);
            ++this.revisionNumber;
        }

        @Override
        public int[] getQueueSizes() {
            FairCallQueue obj = (FairCallQueue)this.delegate.get();
            if (obj == null) {
                return new int[0];
            }
            return obj.getQueueSizes();
        }

        @Override
        public long[] getOverflowedCalls() {
            FairCallQueue obj = (FairCallQueue)this.delegate.get();
            if (obj == null) {
                return new long[0];
            }
            return obj.getOverflowedCalls();
        }

        @Override
        public int getRevision() {
            return this.revisionNumber;
        }
    }
}

