/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.util.Time;

abstract class SocketIOWithTimeout {
    static final Logger LOG = LoggerFactory.getLogger(SocketIOWithTimeout.class);
    private SelectableChannel channel;
    private long timeout;
    private boolean closed = false;
    private static SelectorPool selector = new SelectorPool();

    SocketIOWithTimeout(SelectableChannel channel, long timeout) throws IOException {
        SocketIOWithTimeout.checkChannelValidity(channel);
        this.channel = channel;
        this.timeout = timeout;
        channel.configureBlocking(false);
    }

    void close() {
        this.closed = true;
    }

    boolean isOpen() {
        return !this.closed && this.channel.isOpen();
    }

    SelectableChannel getChannel() {
        return this.channel;
    }

    static void checkChannelValidity(Object channel) throws IOException {
        if (channel == null) {
            throw new IOException("Channel is null. Check how the channel or socket is created.");
        }
        if (!(channel instanceof SelectableChannel)) {
            throw new IOException("Channel should be a SelectableChannel");
        }
    }

    abstract int performIO(ByteBuffer var1) throws IOException;

    int doIO(ByteBuffer buf, int ops) throws IOException {
        if (!buf.hasRemaining()) {
            throw new IllegalArgumentException("Buffer has no data left.");
        }
        while (buf.hasRemaining()) {
            if (this.closed) {
                return -1;
            }
            try {
                int n = this.performIO(buf);
                if (n != 0) {
                    return n;
                }
            }
            catch (IOException e) {
                if (!this.channel.isOpen()) {
                    this.closed = true;
                }
                throw e;
            }
            int count = 0;
            try {
                count = selector.select(this.channel, ops, this.timeout);
            }
            catch (IOException e) {
                this.closed = true;
                throw e;
            }
            if (count != 0) continue;
            throw new SocketTimeoutException(SocketIOWithTimeout.timeoutExceptionString(this.channel, this.timeout, ops));
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    static void connect(SocketChannel channel, SocketAddress endpoint, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void waitForIO(int ops) throws IOException {
        if (selector.select(this.channel, ops, this.timeout) == 0) {
            throw new SocketTimeoutException(SocketIOWithTimeout.timeoutExceptionString(this.channel, this.timeout, ops));
        }
    }

    public void setTimeout(long timeoutMs) {
        this.timeout = timeoutMs;
    }

    private static String timeoutExceptionString(SelectableChannel channel, long timeout, int ops) {
        String waitingFor;
        switch (ops) {
            case 1: {
                waitingFor = "read";
                break;
            }
            case 4: {
                waitingFor = "write";
                break;
            }
            case 8: {
                waitingFor = "connect";
                break;
            }
            default: {
                waitingFor = "" + ops;
            }
        }
        return timeout + " millis timeout while waiting for channel to be ready for " + waitingFor + ". ch : " + channel;
    }

    private static class SelectorPool {
        private static final long IDLE_TIMEOUT = 10000L;
        private ProviderInfo providerList = null;

        private SelectorPool() {
        }

        int select(SelectableChannel channel, int ops, long timeout) throws IOException {
            SelectorInfo info = this.get(channel);
            SelectionKey key = null;
            int ret = 0;
            try {
                while (true) {
                    long start = timeout == 0L ? 0L : Time.now();
                    key = channel.register(info.selector, ops);
                    ret = info.selector.select(timeout);
                    if (ret != 0) {
                        int n = ret;
                        return n;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedIOException("Interrupted while waiting for IO on channel " + channel + ". " + timeout + " millis timeout left.");
                    }
                    if (timeout <= 0L || (timeout -= Time.now() - start) > 0L) continue;
                    int n = 0;
                    return n;
                }
            }
            finally {
                if (key != null) {
                    key.cancel();
                }
                try {
                    info.selector.selectNow();
                }
                catch (IOException e) {
                    LOG.info("Unexpected Exception while clearing selector : ", e);
                    info.close();
                    return ret;
                }
                this.release(info);
            }
        }

        private synchronized SelectorInfo get(SelectableChannel channel) throws IOException {
            LinkedList<SelectorInfo> queue;
            SelectorInfo selInfo = null;
            SelectorProvider provider = channel.provider();
            ProviderInfo pList = this.providerList;
            while (pList != null && pList.provider != provider) {
                pList = pList.next;
            }
            if (pList == null) {
                pList = new ProviderInfo();
                pList.provider = provider;
                pList.queue = new LinkedList();
                pList.next = this.providerList;
                this.providerList = pList;
            }
            if ((queue = pList.queue).isEmpty()) {
                AbstractSelector selector = provider.openSelector();
                selInfo = new SelectorInfo();
                selInfo.selector = selector;
                selInfo.queue = queue;
            } else {
                selInfo = queue.removeLast();
            }
            this.trimIdleSelectors(Time.now());
            return selInfo;
        }

        private synchronized void release(SelectorInfo info) {
            long now = Time.now();
            this.trimIdleSelectors(now);
            info.lastActivityTime = now;
            info.queue.addLast(info);
        }

        private void trimIdleSelectors(long now) {
            long cutoff = now - 10000L;
            ProviderInfo pList = this.providerList;
            while (pList != null) {
                if (!pList.queue.isEmpty()) {
                    Iterator it = pList.queue.iterator();
                    while (it.hasNext()) {
                        SelectorInfo info = (SelectorInfo)it.next();
                        if (info.lastActivityTime > cutoff) break;
                        it.remove();
                        info.close();
                    }
                }
                pList = pList.next;
            }
        }

        private static class ProviderInfo {
            SelectorProvider provider;
            LinkedList<SelectorInfo> queue;
            ProviderInfo next;

            private ProviderInfo() {
            }
        }

        private static class SelectorInfo {
            Selector selector;
            long lastActivityTime;
            LinkedList<SelectorInfo> queue;

            private SelectorInfo() {
            }

            void close() {
                if (this.selector != null) {
                    try {
                        this.selector.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Unexpected exception while closing selector : ", e);
                    }
                }
            }
        }
    }
}

