/*
 * Copyright 2012 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package io.trino.hadoop.$internal.io.netty.example.worldclock;

import io.trino.hadoop.$internal.io.netty.channel.ChannelInitializer;
import io.trino.hadoop.$internal.io.netty.channel.ChannelPipeline;
import io.trino.hadoop.$internal.io.netty.channel.socket.SocketChannel;
import io.trino.hadoop.$internal.io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.trino.hadoop.$internal.io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.trino.hadoop.$internal.io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.trino.hadoop.$internal.io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.trino.hadoop.$internal.io.netty.handler.ssl.SslContext;

public class WorldClockClientInitializer extends ChannelInitializer<SocketChannel> {

    private final SslContext sslCtx;

    public WorldClockClientInitializer(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    @Override
    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        if (sslCtx != null) {
            p.addLast(sslCtx.newHandler(ch.alloc(), WorldClockClient.HOST, WorldClockClient.PORT));
        }

        p.addLast(new ProtobufVarint32FrameDecoder());
        p.addLast(new ProtobufDecoder(WorldClockProtocol.LocalTimes.getDefaultInstance()));

        p.addLast(new ProtobufVarint32LengthFieldPrepender());
        p.addLast(new ProtobufEncoder());

        p.addLast(new WorldClockClientHandler());
    }
}
