/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.io.netty.channel.epoll;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.io.netty.channel.Channel;
import io.trino.hadoop.$internal.io.netty.channel.ChannelOutboundBuffer;
import io.trino.hadoop.$internal.io.netty.channel.ChannelPipeline;
import io.trino.hadoop.$internal.io.netty.channel.ChannelPromise;
import io.trino.hadoop.$internal.io.netty.channel.EventLoop;
import io.trino.hadoop.$internal.io.netty.channel.ServerChannel;
import io.trino.hadoop.$internal.io.netty.channel.epoll.AbstractEpollChannel;
import io.trino.hadoop.$internal.io.netty.channel.epoll.EpollChannelConfig;
import io.trino.hadoop.$internal.io.netty.channel.epoll.Native;
import io.trino.hadoop.$internal.io.netty.channel.unix.FileDescriptor;
import io.trino.hadoop.$internal.io.netty.channel.unix.Socket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class AbstractEpollServerChannel
extends AbstractEpollChannel
implements ServerChannel {
    @Deprecated
    protected AbstractEpollServerChannel(int fd) {
        this(new Socket(fd), false);
    }

    @Deprecated
    protected AbstractEpollServerChannel(FileDescriptor fd) {
        this(new Socket(fd.intValue()));
    }

    @Deprecated
    protected AbstractEpollServerChannel(Socket fd) {
        this(fd, AbstractEpollServerChannel.isSoErrorZero(fd));
    }

    protected AbstractEpollServerChannel(Socket fd, boolean active) {
        super(null, fd, Native.EPOLLIN, active);
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof .EpollEventLoop;
    }

    @Override
    protected InetSocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollServerSocketUnsafe();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object filterOutboundMessage(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    abstract Channel newChildChannel(int var1, byte[] var2, int var3, int var4) throws Exception;

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException();
    }

    final class EpollServerSocketUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        private final byte[] acceptedAddress;

        EpollServerSocketUnsafe() {
            super(AbstractEpollServerChannel.this);
            this.acceptedAddress = new byte[26];
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            channelPromise.setFailure(new UnsupportedOperationException());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            assert (AbstractEpollServerChannel.this.eventLoop().inEventLoop());
            if (AbstractEpollServerChannel.this.fd().isInputShutdown()) {
                return;
            }
            boolean edgeTriggered = AbstractEpollServerChannel.this.isFlagSet(Native.EPOLLET);
            EpollChannelConfig config = AbstractEpollServerChannel.this.config();
            if (!(this.readPending || edgeTriggered || config.isAutoRead())) {
                this.clearEpollIn0();
                return;
            }
            ChannelPipeline pipeline = AbstractEpollServerChannel.this.pipeline();
            Throwable exception = null;
            try {
                try {
                    int socketFd;
                    int maxMessagesPerRead = edgeTriggered ? Integer.MAX_VALUE : config.getMaxMessagesPerRead();
                    int messages = 0;
                    while ((socketFd = AbstractEpollServerChannel.this.fd().accept(this.acceptedAddress)) != -1) {
                        this.readPending = false;
                        try {
                            byte len = this.acceptedAddress[0];
                            pipeline.fireChannelRead(AbstractEpollServerChannel.this.newChildChannel(socketFd, this.acceptedAddress, 1, len));
                        }
                        catch (Throwable t) {
                            pipeline.fireChannelReadComplete();
                            pipeline.fireExceptionCaught(t);
                        }
                        finally {
                            if (edgeTriggered || config.isAutoRead()) {
                            }
                            break;
                        }
                        if (++messages < maxMessagesPerRead || this.isRdHup()) continue;
                        break;
                    }
                }
                catch (Throwable t) {
                    exception = t;
                }
                pipeline.fireChannelReadComplete();
                if (exception != null) {
                    pipeline.fireExceptionCaught(exception);
                }
            }
            finally {
                if (!this.readPending && !config.isAutoRead()) {
                    this.clearEpollIn0();
                }
            }
        }
    }
}

