/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package io.trino.hadoop.$internal.org.apache.commons.compress.harmony.unpack200.bytecode.forms;

import io.trino.hadoop.$internal.org.apache.commons.compress.harmony.unpack200.SegmentConstantPool;
import io.trino.hadoop.$internal.org.apache.commons.compress.harmony.unpack200.bytecode.ByteCode;
import io.trino.hadoop.$internal.org.apache.commons.compress.harmony.unpack200.bytecode.CPInterfaceMethodRef;
import io.trino.hadoop.$internal.org.apache.commons.compress.harmony.unpack200.bytecode.OperandManager;

/**
 * This class implements the byte code form for those bytecodes which have IMethod references (and only IMethod
 * references).
 */
public class IMethodRefForm extends ReferenceForm {

    public IMethodRefForm(final int opcode, final String name, final int[] rewrite) {
        super(opcode, name, rewrite);
    }

    @Override
    protected int getOffset(final OperandManager operandManager) {
        return operandManager.nextIMethodRef();
    }

    @Override
    protected int getPoolID() {
        return SegmentConstantPool.CP_IMETHOD;
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * io.trino.hadoop.$internal.org.apache.commons.compress.harmony.unpack200.bytecode.forms.ByteCodeForm#setByteCodeOperands(io.trino.hadoop.$internal.org.apache.commons.
     * compress.harmony.unpack200.bytecode.ByteCode,
     * io.trino.hadoop.$internal.org.apache.commons.compress.harmony.unpack200.bytecode.OperandTable,
     * io.trino.hadoop.$internal.org.apache.commons.compress.harmony.unpack200.Segment)
     */
    @Override
    public void setByteCodeOperands(final ByteCode byteCode, final OperandManager operandManager,
        final int codeLength) {
        super.setByteCodeOperands(byteCode, operandManager, codeLength);
        final int count = ((CPInterfaceMethodRef) byteCode.getNestedClassFileEntries()[0]).invokeInterfaceCount();
        byteCode.getRewrite()[3] = count;
    }
}
