/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.message.AdminMessageCode;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.message.AdminMessageType;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.message.RenamePrincipalReq;
import io.trino.hadoop.$internal.org.apache.kerby.xdr.XdrDataType;
import io.trino.hadoop.$internal.org.apache.kerby.xdr.XdrFieldInfo;

import java.io.IOException;
import java.nio.ByteBuffer;

/**
 * RenamePrincipal request.
 */
public class RenamePrincipalRequest extends AdminRequest {
    String newPrincipalName;

    public RenamePrincipalRequest(String oldPrincipalName, String newPrincipalName) {
        super(oldPrincipalName);
        this.newPrincipalName = newPrincipalName;
    }

    @Override
    public void process() throws KrbException {
        super.process();

        RenamePrincipalReq renamePrincipalReq = new RenamePrincipalReq();

        /** encode admin message:
         *  encode type
         *  encode paranum
         *  encode old principal name
         *  encode new principal name
         */
        int paramNum = 2;
        XdrFieldInfo[] xdrFieldInfos = new XdrFieldInfo[paramNum + 2];
        xdrFieldInfos[0] = new XdrFieldInfo(0, XdrDataType.ENUM, AdminMessageType.RENAME_PRINCIPAL_REQ);
        xdrFieldInfos[1] = new XdrFieldInfo(1, XdrDataType.INTEGER, paramNum);
        xdrFieldInfos[2] = new XdrFieldInfo(2, XdrDataType.STRING, getPrincipal());
        xdrFieldInfos[3] = new XdrFieldInfo(3, XdrDataType.STRING, newPrincipalName);

        AdminMessageCode value = new AdminMessageCode(xdrFieldInfos);
        byte[] encodeBytes;
        try {
            encodeBytes = value.encode();
        } catch (IOException e) {
            throw new KrbException("Xdr encode error when generate rename principal request.", e);
        }
        ByteBuffer messageBuffer = ByteBuffer.wrap(encodeBytes);
        renamePrincipalReq.setMessageBuffer(messageBuffer);

        setAdminReq(renamePrincipalReq);
    }
}
