/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.PaFlags;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.PluginRequestContext;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.PreauthPluginMeta;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcContext;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaData;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;

/**
 * KDC side preauth plugin module
 */
public interface KdcPreauth extends PreauthPluginMeta {

    /**
     * Initializing plugin context for each realm
     * @param context kdc context
     */
    void initWith(KdcContext context);

    /**
     * Initializing request context
     * @param kdcRequest kdc context
     * @return request context
     */
    PluginRequestContext initRequestContext(KdcRequest kdcRequest);

    /**
     * Optional: provide pa_data to send to the client as part of the "you need to
     * use preauthentication" error.
     *
     * @param kdcRequest kdc request
     * @param requestContext request context
     * @param outPaData out preauthentication data
     * @throws KrbException e
     */
    void provideEdata(KdcRequest kdcRequest, PluginRequestContext requestContext,
                             PaData outPaData) throws KrbException;

    /**
     * Optional: verify preauthentication data sent by the client, setting the
     * TKT_FLG_PRE_AUTH or TKT_FLG_HW_AUTH flag in the enc_tkt_reply's "flags"
     * field as appropriate.
     * @param kdcRequest kdc request
     * @param requestContext request context
     * @param paData preauthentication data
     * @return true if verify success
     * @throws KrbException e
     */
    boolean verify(KdcRequest kdcRequest, PluginRequestContext requestContext,
                          PaDataEntry paData) throws KrbException;

    /**
     * Optional: generate preauthentication response data to send to the client as
     * part of the AS-REP.
     * @param kdcRequest kdc request
     * @param requestContext request context
     * @param paData preauthentication data
     */
    void providePaData(KdcRequest kdcRequest, PluginRequestContext requestContext,
                              PaData paData);

    /**
     * Return PA_REAL if pa_type is a real preauthentication type or PA_INFO if it is
     * an informational type.
     * @param kdcRequest kdc request
     * @param requestContext request context
     * @param paType preauthentication type
     * @return PaFlags
     */
    PaFlags getFlags(KdcRequest kdcRequest, PluginRequestContext requestContext,
                            PaDataType paType);

    /**
     * When exiting...
     */
    void destroy();

}
