package io.trino.hadoop.$internal.org.checkerframework.checker.i18nformatter.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.InvisibleQualifier;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.SubtypeOf;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.TargetLocations;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The top qualifier.
 *
 * <p>A type annotation indicating that the run-time value might or might not be a valid i18n format
 * string.
 *
 * @checker_framework.manual #i18n-formatter-checker Internationalization Format String Checker
 */
@InvisibleQualifier
@SubtypeOf({})
@DefaultQualifierInHierarchy
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
public @interface I18nUnknownFormat {}
