package io.trino.hadoop.$internal.org.checkerframework.checker.index.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.ImplicitFor;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.LiteralKind;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.SubtypeOf;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.TargetLocations;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The bottom type in the Search Index type system. Programmers should rarely write this type.
 *
 * @checker_framework.manual #index-checker Index Checker
 * @checker_framework.manual #bottom-type the bottom type
 */
@SubtypeOf(NegativeIndexFor.class)
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@ImplicitFor(literals = LiteralKind.NULL, typeNames = java.lang.Void.class)
public @interface SearchIndexBottom {}
