package io.trino.hadoop.$internal.org.checkerframework.checker.nullness.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.DefaultFor;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.InvisibleQualifier;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.SubtypeOf;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * Used internally by the type system; should never be written by a programmer.
 *
 * <p>Indicates that the value assigned to the annotated variable is not known to be a key for any
 * map. It is the top type qualifier in the {@link KeyFor} hierarchy. It is also the default type
 * qualifier.
 *
 * @checker_framework.manual #map-key-checker Map Key Checker
 */
@InvisibleQualifier
@SubtypeOf({})
@DefaultQualifierInHierarchy
@DefaultFor({TypeUseLocation.LOWER_BOUND})
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
public @interface UnknownKeyFor {}
