package io.trino.hadoop.$internal.org.checkerframework.checker.regex.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.InvisibleQualifier;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.SubtypeOf;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.TargetLocations;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * Represents the top of the Regex qualifier hierarchy.
 *
 * @checker_framework.manual #regex-checker Regex Checker
 */
@InvisibleQualifier
@DefaultQualifierInHierarchy
@SubtypeOf({})
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
public @interface UnknownRegex {}
