package io.trino.hadoop.$internal.org.checkerframework.checker.units.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.InvisibleQualifier;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.SubtypeOf;

/**
 * UnknownUnits is the top type of the type hierarchy.
 *
 * @checker_framework.manual #units-checker Units Checker
 */
@InvisibleQualifier
@SubtypeOf({})
@DefaultQualifierInHierarchy
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
public @interface UnknownUnits {}
