package io.trino.hadoop.$internal.org.checkerframework.common.reflection.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.InvisibleQualifier;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.SubtypeOf;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.TargetLocations;
import io.trino.hadoop.$internal.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * Represents a Class object whose run-time value is not known at compile time. Also represents
 * non-Class values.
 *
 * <p>This annotation is the default in the hierarchy.
 *
 * @checker_framework.manual #methodval-and-classval-checkers ClassVal Checker
 */
@InvisibleQualifier
@SubtypeOf({})
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@DefaultQualifierInHierarchy
public @interface UnknownClass {}
