//
//  ========================================================================
//  Copyright (c) 1995-2022 Mort Bay Consulting Pty Ltd and others.
//  ------------------------------------------------------------------------
//  All rights reserved. This program and the accompanying materials
//  are made available under the terms of the Eclipse Public License v1.0
//  and Apache License v2.0 which accompanies this distribution.
//
//      The Eclipse Public License is available at
//      http://www.eclipse.org/legal/epl-v10.html
//
//      The Apache License v2.0 is available at
//      http://www.opensource.org/licenses/apache2.0.php
//
//  You may elect to redistribute this code under either of these licenses.
//  ========================================================================
//

package io.trino.hadoop.$internal.org.eclipse.jetty.util;

/**
 * A {@link Throwable} that may be used in static contexts. It uses Java 7
 * constructor that prevents setting stackTrace inside exception object.
 */
public class ConstantThrowable extends Throwable
{
    public ConstantThrowable()
    {
        this(null);
    }

    public ConstantThrowable(String name)
    {
        super(name, null, false, false);
    }

    @Override
    public String toString()
    {
        return String.valueOf(getMessage());
    }
}
