/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.io.nativeio.NativeIOException;

public class AtomicFileOutputStream
extends FilterOutputStream {
    private static final String TMP_EXTENSION = ".tmp";
    private static final Logger LOG = LoggerFactory.getLogger(AtomicFileOutputStream.class);
    private final File origFile;
    private final File tmpFile;

    public AtomicFileOutputStream(File f) throws FileNotFoundException {
        super(new FileOutputStream(new File(f.getParentFile(), f.getName() + TMP_EXTENSION)));
        this.origFile = f.getAbsoluteFile();
        this.tmpFile = new File(f.getParentFile(), f.getName() + TMP_EXTENSION).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean triedToClose = false;
        boolean success = false;
        try {
            this.flush();
            ((FileOutputStream)this.out).getChannel().force(true);
            triedToClose = true;
            super.close();
            success = true;
        }
        finally {
            if (success) {
                boolean renamed = this.tmpFile.renameTo(this.origFile);
                if (!renamed) {
                    if (this.origFile.exists() && !this.origFile.delete()) {
                        throw new IOException("Could not delete original file " + this.origFile);
                    }
                    try {
                        NativeIO.renameTo(this.tmpFile, this.origFile);
                    }
                    catch (NativeIOException e) {
                        throw new IOException("Could not rename temporary file " + this.tmpFile + " to " + this.origFile + " due to failure in native rename. " + e.toString());
                    }
                }
            } else {
                if (!triedToClose) {
                    IOUtils.closeStream(this.out);
                }
                if (!this.tmpFile.delete()) {
                    LOG.warn("Unable to delete tmp file " + this.tmpFile);
                }
            }
        }
    }

    public void abort() {
        try {
            super.close();
        }
        catch (IOException ioe) {
            LOG.warn("Unable to abort file " + this.tmpFile, ioe);
        }
        if (!this.tmpFile.delete()) {
            LOG.warn("Unable to delete tmp file during abort " + this.tmpFile);
        }
    }
}

