/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.net.sf.jpam.jaas;

import io.trino.hive.jdbc.$internal.net.sf.jpam.Pam;
import io.trino.hive.jdbc.$internal.net.sf.jpam.PamReturnValue;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class JpamLoginModule
implements LoginModule {
    private static final Log LOG = LogFactory.getLog((class$net$sf$jpam$jaas$JpamLoginModule == null ? (class$net$sf$jpam$jaas$JpamLoginModule = JpamLoginModule.class$("io.trino.hive.jdbc.$internal.net.sf.jpam.jaas.JpamLoginModule")) : class$net$sf$jpam$jaas$JpamLoginModule).getName());
    private static final String SERVICE_NAME_OPTION = "serviceName";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private Pam pam;
    static /* synthetic */ Class class$net$sf$jpam$jaas$JpamLoginModule;

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean login() throws LoginException {
        this.pam = this.createPam();
        Callback[] callbacks = new Callback[2];
        String username = null;
        NameCallback nameCallback = new NameCallback("Enter Username: ");
        callbacks[0] = nameCallback;
        String credentials = null;
        PasswordCallback passwordCallback = new PasswordCallback("Enter Credentials: ", false);
        callbacks[1] = passwordCallback;
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            LOG.error("IOException handling login: " + e.getMessage(), e);
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            LOG.error("UnsupportedCallbackException handling login: " + e.getMessage(), e);
            throw new LoginException(e.getMessage());
        }
        username = nameCallback.getName();
        credentials = String.copyValueOf(passwordCallback.getPassword());
        boolean authenticated = false;
        PamReturnValue pamReturnValue = this.pam.authenticate(username, credentials);
        if (!pamReturnValue.equals(PamReturnValue.PAM_SUCCESS)) {
            if (pamReturnValue.equals(PamReturnValue.PAM_ACCT_EXPIRED)) {
                throw new AccountExpiredException(PamReturnValue.PAM_ACCT_EXPIRED.toString());
            }
            if (pamReturnValue.equals(PamReturnValue.PAM_CRED_EXPIRED)) {
                throw new CredentialExpiredException(PamReturnValue.PAM_CRED_EXPIRED.toString());
            }
            throw new FailedLoginException(pamReturnValue.toString());
        }
        authenticated = true;
        return authenticated;
    }

    private Pam createPam() {
        String serviceName = (String)this.options.get(SERVICE_NAME_OPTION);
        if (serviceName == null) {
            LOG.debug("No serviceName configured in JAAS configuration file. Using default service name of net-sf-jpam");
            serviceName = "net-sf-jpam";
        } else {
            LOG.debug("Using service name of " + serviceName + " from JAAS configuration file");
        }
        Pam pam = new Pam(serviceName);
        return pam;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    public Pam getPam() {
        return this.pam;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

