/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsPermission;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactories;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PermissionStatus
implements Writable {
    static final WritableFactory FACTORY = new WritableFactory(){

        @Override
        public Writable newInstance() {
            return new PermissionStatus();
        }
    };
    private String username;
    private String groupname;
    private FsPermission permission;

    public static PermissionStatus createImmutable(String user, String group, FsPermission permission) {
        return new PermissionStatus(user, group, permission){

            @Override
            public PermissionStatus applyUMask(FsPermission umask) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void readFields(DataInput in) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private PermissionStatus() {
    }

    public PermissionStatus(String user, String group, FsPermission permission) {
        this.username = user;
        this.groupname = group;
        this.permission = permission;
    }

    public String getUserName() {
        return this.username;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public FsPermission getPermission() {
        return this.permission;
    }

    public PermissionStatus applyUMask(FsPermission umask) {
        this.permission = this.permission.applyUMask(umask);
        return this;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.username = Text.readString(in);
        this.groupname = Text.readString(in);
        this.permission = FsPermission.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        PermissionStatus.write(out, this.username, this.groupname, this.permission);
    }

    public static PermissionStatus read(DataInput in) throws IOException {
        PermissionStatus p = new PermissionStatus();
        p.readFields(in);
        return p;
    }

    public static void write(DataOutput out, String username, String groupname, FsPermission permission) throws IOException {
        Text.writeString(out, username);
        Text.writeString(out, groupname);
        permission.write(out);
    }

    public String toString() {
        return this.username + ":" + this.groupname + ":" + this.permission;
    }

    static {
        WritableFactories.setFactory(PermissionStatus.class, FACTORY);
    }
}

