/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.ContentSummary;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsPermission;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission.PermissionStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.Block;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.LocatedBlock;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

abstract class INode
implements Comparable<byte[]> {
    protected byte[] name;
    protected INodeDirectory parent;
    protected long modificationTime;
    protected long accessTime;
    private long permission;

    protected INode() {
        this.name = null;
        this.parent = null;
        this.modificationTime = 0L;
        this.accessTime = 0L;
    }

    INode(PermissionStatus permissions, long mTime, long atime) {
        this.name = null;
        this.parent = null;
        this.modificationTime = mTime;
        this.setAccessTime(atime);
        this.setPermissionStatus(permissions);
    }

    protected INode(String name, PermissionStatus permissions) {
        this(permissions, 0L, 0L);
        this.setLocalName(name);
    }

    INode(INode other) {
        this.setLocalName(other.getLocalName());
        this.parent = other.getParent();
        this.setPermissionStatus(other.getPermissionStatus());
        this.setModificationTime(other.getModificationTime());
        this.setAccessTime(other.getAccessTime());
    }

    boolean isRoot() {
        return this.name.length == 0;
    }

    protected void setPermissionStatus(PermissionStatus ps) {
        this.setUser(ps.getUserName());
        this.setGroup(ps.getGroupName());
        this.setPermission(ps.getPermission());
    }

    protected PermissionStatus getPermissionStatus() {
        return new PermissionStatus(this.getUserName(), this.getGroupName(), this.getFsPermission());
    }

    private synchronized void updatePermissionStatus(PermissionStatusFormat f, long n) {
        this.permission = f.combine(n, this.permission);
    }

    public String getUserName() {
        int n = (int)PermissionStatusFormat.USER.retrieve(this.permission);
        return SerialNumberManager.INSTANCE.getUser(n);
    }

    protected void setUser(String user) {
        int n = SerialNumberManager.INSTANCE.getUserSerialNumber(user);
        this.updatePermissionStatus(PermissionStatusFormat.USER, n);
    }

    public String getGroupName() {
        int n = (int)PermissionStatusFormat.GROUP.retrieve(this.permission);
        return SerialNumberManager.INSTANCE.getGroup(n);
    }

    protected void setGroup(String group) {
        int n = SerialNumberManager.INSTANCE.getGroupSerialNumber(group);
        this.updatePermissionStatus(PermissionStatusFormat.GROUP, n);
    }

    public FsPermission getFsPermission() {
        return new FsPermission((short)PermissionStatusFormat.MODE.retrieve(this.permission));
    }

    protected short getFsPermissionShort() {
        return (short)PermissionStatusFormat.MODE.retrieve(this.permission);
    }

    protected void setPermission(FsPermission permission) {
        this.updatePermissionStatus(PermissionStatusFormat.MODE, permission.toShort());
    }

    public abstract boolean isDirectory();

    abstract int collectSubtreeBlocksAndClear(List<Block> var1);

    public final ContentSummary computeContentSummary() {
        long[] a = this.computeContentSummary(new long[]{0L, 0L, 0L, 0L});
        return new ContentSummary(a[0], a[1], a[2], this.getNsQuota(), a[3], this.getDsQuota());
    }

    abstract long[] computeContentSummary(long[] var1);

    long getNsQuota() {
        return -1L;
    }

    long getDsQuota() {
        return -1L;
    }

    boolean isQuotaSet() {
        return this.getNsQuota() >= 0L || this.getDsQuota() >= 0L;
    }

    abstract DirCounts spaceConsumedInTree(DirCounts var1);

    String getLocalName() {
        return INode.bytes2String(this.name);
    }

    byte[] getLocalNameBytes() {
        return this.name;
    }

    void setLocalName(String name) {
        this.name = INode.string2Bytes(name);
    }

    void setLocalName(byte[] name) {
        this.name = name;
    }

    public String toString() {
        return "\"" + this.getLocalName() + "\":" + this.getPermissionStatus();
    }

    INodeDirectory getParent() {
        return this.parent;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    void setModificationTime(long modtime) {
        assert (this.isDirectory());
        if (this.modificationTime <= modtime) {
            this.modificationTime = modtime;
        }
    }

    void setModificationTimeForce(long modtime) {
        assert (!this.isDirectory());
        this.modificationTime = modtime;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    void setAccessTime(long atime) {
        this.accessTime = atime;
    }

    boolean isUnderConstruction() {
        return false;
    }

    static byte[][] getPathComponents(String path) {
        return INode.getPathComponents(INode.getPathNames(path));
    }

    static byte[][] getPathComponents(String[] strings) {
        if (strings.length == 0) {
            return new byte[][]{null};
        }
        byte[][] bytes = new byte[strings.length][];
        for (int i = 0; i < strings.length; ++i) {
            bytes[i] = INode.string2Bytes(strings[i]);
        }
        return bytes;
    }

    static String[] getPathNames(String path) {
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        return path.split("/");
    }

    boolean removeNode() {
        if (this.parent == null) {
            return false;
        }
        this.parent.removeChild(this);
        this.parent = null;
        return true;
    }

    @Override
    public int compareTo(byte[] o) {
        return INode.compareBytes(this.name, o);
    }

    public boolean equals(Object o) {
        if (!(o instanceof INode)) {
            return false;
        }
        return Arrays.equals(this.name, ((INode)o).name);
    }

    public int hashCode() {
        return Arrays.hashCode(this.name);
    }

    static int compareBytes(byte[] a1, byte[] a2) {
        if (a1 == a2) {
            return 0;
        }
        int len1 = a1 == null ? 0 : a1.length;
        int len2 = a2 == null ? 0 : a2.length;
        int n = Math.min(len1, len2);
        for (int i = 0; i < n; ++i) {
            byte b1 = a1[i];
            byte b2 = a2[i];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    static String bytes2String(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    static byte[] string2Bytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    LocatedBlocks createLocatedBlocks(List<LocatedBlock> blocks) {
        return new LocatedBlocks(this.computeContentSummary().getLength(), blocks, this.isUnderConstruction());
    }

    private static enum PermissionStatusFormat {
        MODE(0, 16),
        GROUP(PermissionStatusFormat.MODE.OFFSET + PermissionStatusFormat.MODE.LENGTH, 25),
        USER(PermissionStatusFormat.GROUP.OFFSET + PermissionStatusFormat.GROUP.LENGTH, 23);

        final int OFFSET;
        final int LENGTH;
        final long MASK;

        private PermissionStatusFormat(int offset, int length) {
            this.OFFSET = offset;
            this.LENGTH = length;
            this.MASK = -1L >>> 64 - this.LENGTH << this.OFFSET;
        }

        long retrieve(long record) {
            return (record & this.MASK) >>> this.OFFSET;
        }

        long combine(long bits, long record) {
            return record & (this.MASK ^ 0xFFFFFFFFFFFFFFFFL) | bits << this.OFFSET;
        }
    }

    static class DirCounts {
        long nsCount = 0L;
        long dsCount = 0L;

        DirCounts() {
        }

        long getNsCount() {
            return this.nsCount;
        }

        long getDsCount() {
            return this.dsCount;
        }
    }
}

