/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission.PermissionStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INode;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INodeDirectory;

class INodeDirectoryWithQuota
extends INodeDirectory {
    private long nsQuota;
    private long nsCount;
    private long dsQuota;
    private long diskspace;

    INodeDirectoryWithQuota(long nsQuota, long dsQuota, INodeDirectory other) throws QuotaExceededException {
        super(other);
        INode.DirCounts counts = new INode.DirCounts();
        other.spaceConsumedInTree(counts);
        this.nsCount = counts.getNsCount();
        this.diskspace = counts.getDsCount();
        this.setQuota(nsQuota, dsQuota);
    }

    INodeDirectoryWithQuota(PermissionStatus permissions, long modificationTime, long nsQuota, long dsQuota) {
        super(permissions, modificationTime);
        this.nsQuota = nsQuota;
        this.dsQuota = dsQuota;
        this.nsCount = 1L;
    }

    INodeDirectoryWithQuota(String name, PermissionStatus permissions, long nsQuota, long dsQuota) {
        super(name, permissions);
        this.nsQuota = nsQuota;
        this.dsQuota = dsQuota;
        this.nsCount = 1L;
    }

    @Override
    long getNsQuota() {
        return this.nsQuota;
    }

    @Override
    long getDsQuota() {
        return this.dsQuota;
    }

    void setQuota(long newNsQuota, long newDsQuota) throws QuotaExceededException {
        this.nsQuota = newNsQuota;
        this.dsQuota = newDsQuota;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) {
        counts.nsCount += this.nsCount;
        counts.dsCount += this.diskspace;
        return counts;
    }

    long numItemsInTree() {
        return this.nsCount;
    }

    long diskspaceConsumed() {
        return this.diskspace;
    }

    void updateNumItemsInTree(long nsDelta, long dsDelta) {
        this.nsCount += nsDelta;
        this.diskspace += dsDelta;
    }

    void setSpaceConsumed(long namespace, long diskspace) {
        this.nsCount = namespace;
        this.diskspace = diskspace;
    }

    void verifyQuota(long nsDelta, long dsDelta) throws QuotaExceededException {
        long newCount = this.nsCount + nsDelta;
        long newDiskspace = this.diskspace + dsDelta;
        if (nsDelta > 0L || dsDelta > 0L) {
            if (this.nsQuota >= 0L && this.nsQuota < newCount) {
                throw new NSQuotaExceededException(this.nsQuota, newCount);
            }
            if (this.dsQuota >= 0L && this.dsQuota < newDiskspace) {
                throw new DSQuotaExceededException(this.dsQuota, newDiskspace);
            }
        }
    }
}

