/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.protocol;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactories;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class DatanodeCommand
implements Writable {
    public static final DatanodeCommand REGISTER;
    public static final DatanodeCommand FINALIZE;
    private int action;

    public DatanodeCommand() {
        this(0);
    }

    DatanodeCommand(int action) {
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.action);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.action = in.readInt();
    }

    static {
        WritableFactories.setFactory(Register.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new Register();
            }
        });
        WritableFactories.setFactory(Finalize.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new Finalize();
            }
        });
        REGISTER = new Register();
        FINALIZE = new Finalize();
    }

    static class Finalize
    extends DatanodeCommand {
        private Finalize() {
            super(5);
        }

        @Override
        public void readFields(DataInput in) {
        }

        @Override
        public void write(DataOutput out) {
        }
    }

    static class Register
    extends DatanodeCommand {
        private Register() {
            super(4);
        }

        @Override
        public void readFields(DataInput in) {
        }

        @Override
        public void write(DataOutput out) {
        }
    }
}

