/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.jdbc;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.jdbc.HiveConnection;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class HiveDriver
implements Driver {
    private static final boolean JDBC_COMPLIANT = false;
    private static final String URL_PREFIX = "jdbc:hive://";
    private static final String DEFAULT_PORT = "10000";
    private static final String DBNAME_PROPERTY_KEY = "DBNAME";
    private static final String HOST_PROPERTY_KEY = "HOST";
    private static final String PORT_PROPERTY_KEY = "PORT";
    private static Attributes manifestAttributes;

    public HiveDriver() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite("foobah");
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Pattern.matches("jdbc:hive://.*", url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return new HiveConnection(url, info);
    }

    static int getMajorDriverVersion() {
        int version = -1;
        try {
            String fullVersion = HiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
            String[] tokens = fullVersion.split("\\.");
            if (tokens != null && tokens.length > 0 && tokens[0] != null) {
                version = Integer.parseInt(tokens[0]);
            }
        }
        catch (Exception e) {
            version = -1;
        }
        return version;
    }

    static int getMinorDriverVersion() {
        int version = -1;
        try {
            String fullVersion = HiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
            String[] tokens = fullVersion.split("\\.");
            if (tokens != null && tokens.length > 1 && tokens[1] != null) {
                version = Integer.parseInt(tokens[1]);
            }
        }
        catch (Exception e) {
            version = -1;
        }
        return version;
    }

    @Override
    public int getMajorVersion() {
        return HiveDriver.getMajorDriverVersion();
    }

    @Override
    public int getMinorVersion() {
        return HiveDriver.getMinorDriverVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith(URL_PREFIX)) {
            info = this.parseURL(url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo(HOST_PROPERTY_KEY, info.getProperty(HOST_PROPERTY_KEY, ""));
        hostProp.required = false;
        hostProp.description = "Hostname of Hive Server";
        DriverPropertyInfo portProp = new DriverPropertyInfo(PORT_PROPERTY_KEY, info.getProperty(PORT_PROPERTY_KEY, ""));
        portProp.required = false;
        portProp.description = "Port number of Hive Server";
        DriverPropertyInfo dbProp = new DriverPropertyInfo(DBNAME_PROPERTY_KEY, info.getProperty(DBNAME_PROPERTY_KEY, "default"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostProp, portProp, dbProp};
        return dpi;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    private Properties parseURL(String url, Properties defaults) throws SQLException {
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? new Properties(defaults) : new Properties();
        if (url == null || !url.startsWith(URL_PREFIX)) {
            throw new SQLException("Invalid connection url: " + url);
        }
        if (url.length() <= URL_PREFIX.length()) {
            return urlProps;
        }
        String connectionInfo = url.substring(URL_PREFIX.length());
        String[] hostPortAndDatabase = connectionInfo.split("/", 2);
        if (hostPortAndDatabase[0].length() > 0) {
            String[] hostAndPort = hostPortAndDatabase[0].split(":", 2);
            urlProps.put(HOST_PROPERTY_KEY, hostAndPort[0]);
            if (hostAndPort.length > 1) {
                urlProps.put(PORT_PROPERTY_KEY, hostAndPort[1]);
            } else {
                urlProps.put(PORT_PROPERTY_KEY, DEFAULT_PORT);
            }
        }
        if (hostPortAndDatabase.length > 1) {
            urlProps.put(DBNAME_PROPERTY_KEY, hostPortAndDatabase[1]);
        }
        return urlProps;
    }

    private static synchronized void loadManifestAttributes() throws IOException {
        if (manifestAttributes != null) {
            return;
        }
        Class<HiveDriver> clazz = HiveDriver.class;
        String classContainer = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
        URL manifestUrl = new URL("jar:" + classContainer + "!/META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest(manifestUrl.openStream());
        manifestAttributes = manifest.getMainAttributes();
    }

    static String fetchManifestAttribute(Attributes.Name attributeName) throws SQLException {
        try {
            HiveDriver.loadManifestAttributes();
        }
        catch (IOException e) {
            throw new SQLException("Couldn't load manifest attributes.", e);
        }
        return manifestAttributes.getValue(attributeName);
    }

    static {
        try {
            DriverManager.registerDriver(new HiveDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        manifestAttributes = null;
    }
}

