/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.io;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.AbstractMapWritable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapWritable
extends AbstractMapWritable
implements Map<Writable, Writable> {
    private Map<Writable, Writable> instance = new HashMap<Writable, Writable>();

    public MapWritable() {
    }

    public MapWritable(MapWritable other) {
        this();
        this.copy(other);
    }

    @Override
    public void clear() {
        this.instance.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.instance.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.instance.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Writable, Writable>> entrySet() {
        return this.instance.entrySet();
    }

    @Override
    public Writable get(Object key) {
        return this.instance.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.instance.isEmpty();
    }

    @Override
    public Set<Writable> keySet() {
        return this.instance.keySet();
    }

    @Override
    public Writable put(Writable key, Writable value) {
        this.addToMap(key.getClass());
        this.addToMap(value.getClass());
        return this.instance.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Writable, ? extends Writable> t) {
        for (Map.Entry<? extends Writable, ? extends Writable> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Writable remove(Object key) {
        return this.instance.remove(key);
    }

    @Override
    public int size() {
        return this.instance.size();
    }

    @Override
    public Collection<Writable> values() {
        return this.instance.values();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.instance.size());
        for (Map.Entry<Writable, Writable> e : this.instance.entrySet()) {
            out.writeByte(this.getId(e.getKey().getClass()));
            e.getKey().write(out);
            out.writeByte(this.getId(e.getValue().getClass()));
            e.getValue().write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.instance.clear();
        int entries = in.readInt();
        for (int i = 0; i < entries; ++i) {
            Writable key = (Writable)ReflectionUtils.newInstance(this.getClass(in.readByte()), this.getConf());
            key.readFields(in);
            Writable value = (Writable)ReflectionUtils.newInstance(this.getClass(in.readByte()), this.getConf());
            value.readFields(in);
            this.instance.put(key, value);
        }
    }
}

