/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configured;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Deserializer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Serialization;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Serializer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class SerializationFactory
extends Configured {
    private static final Log LOG = LogFactory.getLog(SerializationFactory.class.getName());
    private List<Serialization<?>> serializations = new ArrayList();

    public SerializationFactory(Configuration conf) {
        super(conf);
        for (String serializerName : conf.getStrings("io.serializations", "io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer.WritableSerialization")) {
            this.add(conf, serializerName);
        }
    }

    private void add(Configuration conf, String serializationName) {
        try {
            Class<?> serializionClass = conf.getClassByName(serializationName);
            this.serializations.add((Serialization)ReflectionUtils.newInstance(serializionClass, this.getConf()));
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Serilization class not found: " + StringUtils.stringifyException(e));
        }
    }

    public <T> Serializer<T> getSerializer(Class<T> c) {
        return this.getSerialization(c).getSerializer(c);
    }

    public <T> Deserializer<T> getDeserializer(Class<T> c) {
        return this.getSerialization(c).getDeserializer(c);
    }

    public <T> Serialization<T> getSerialization(Class<T> c) {
        for (Serialization<T> serialization : this.serializations) {
            if (!serialization.accept(c)) continue;
            return serialization;
        }
        return null;
    }
}

