/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobInProgress;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobPriority;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobProfile;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobTracker;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ServletUtil;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class JSPUtil {
    private static final String PRIVATE_ACTIONS_KEY = "webinterface.private.actions";
    public static final Configuration conf = new Configuration();

    JSPUtil() {
    }

    public static void processButtons(HttpServletRequest request, HttpServletResponse response, JobTracker tracker) throws IOException {
        String[] jobs;
        if (conf.getBoolean(PRIVATE_ACTIONS_KEY, false) && request.getParameter("killJobs") != null && (jobs = request.getParameterValues("jobCheckBox")) != null) {
            for (String job : jobs) {
                tracker.killJob(JobID.forName(job));
            }
        }
        if (conf.getBoolean(PRIVATE_ACTIONS_KEY, false) && request.getParameter("changeJobPriority") != null && (jobs = request.getParameterValues("jobCheckBox")) != null) {
            JobPriority jobPri = JobPriority.valueOf(request.getParameter("setJobPriority"));
            for (String job : jobs) {
                tracker.setJobPriority(JobID.forName(job), jobPri);
            }
        }
    }

    public static String generateJobTable(String label, Collection<JobInProgress> jobs, int refresh, int rowId) throws IOException {
        boolean isModifiable = label.equals("Running") && conf.getBoolean(PRIVATE_ACTIONS_KEY, false);
        StringBuffer sb = new StringBuffer();
        sb.append("<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n");
        if (jobs.size() > 0) {
            if (isModifiable) {
                sb.append("<form action=\"/jobtracker.jsp\" onsubmit=\"return confirmAction();\" method=\"POST\">");
                sb.append("<tr>");
                sb.append("<td><input type=\"Button\" onclick=\"selectAll()\" value=\"Select All\" id=\"checkEm\"></td>");
                sb.append("<td>");
                sb.append("<input type=\"submit\" name=\"killJobs\" value=\"Kill Selected Jobs\">");
                sb.append("</td");
                sb.append("<td><nobr>");
                sb.append("<select name=\"setJobPriority\">");
                for (JobPriority prio : JobPriority.values()) {
                    sb.append("<option" + (JobPriority.NORMAL == prio ? " selected=\"selected\">" : ">") + (Object)((Object)prio) + "</option>");
                }
                sb.append("</select>");
                sb.append("<input type=\"submit\" name=\"changeJobPriority\" value=\"Change\">");
                sb.append("</nobr></td>");
                sb.append("<td colspan=\"10\">&nbsp;</td>");
                sb.append("</tr>");
                sb.append("<td>&nbsp;</td>");
            } else {
                sb.append("<tr>");
            }
            sb.append("<td><b>Jobid</b></td><td><b>Priority</b></td><td><b>User</b></td>");
            sb.append("<td><b>Name</b></td>");
            sb.append("<td><b>Map % Complete</b></td>");
            sb.append("<td><b>Map Total</b></td>");
            sb.append("<td><b>Maps Completed</b></td>");
            sb.append("<td><b>Reduce % Complete</b></td>");
            sb.append("<td><b>Reduce Total</b></td>");
            sb.append("<td><b>Reduces Completed</b></td>");
            sb.append("<td><b>Job Scheduling Information</b></td>");
            sb.append("</tr>\n");
            for (JobInProgress job : jobs) {
                JobProfile profile = job.getProfile();
                JobStatus status = job.getStatus();
                JobID jobid = profile.getJobID();
                int desiredMaps = job.desiredMaps();
                int desiredReduces = job.desiredReduces();
                int completedMaps = job.finishedMaps();
                int completedReduces = job.finishedReduces();
                String name = profile.getJobName();
                String jobpri = job.getPriority().toString();
                String schedulingInfo = job.getStatus().getSchedulingInfo();
                if (isModifiable) {
                    sb.append("<tr><td><input TYPE=\"checkbox\" onclick=\"checkButtonVerbage()\" name=\"jobCheckBox\" value=" + jobid + "></td>");
                } else {
                    sb.append("<tr>");
                }
                sb.append("<td id=\"job_" + rowId + "\"><a href=\"jobdetails.jsp?jobid=" + jobid + "&refresh=" + refresh + "\">" + jobid + "</a></td>" + "<td id=\"priority_" + rowId + "\">" + jobpri + "</td>" + "<td id=\"user_" + rowId + "\">" + profile.getUser() + "</td>" + "<td id=\"name_" + rowId + "\">" + ("".equals(name) ? "&nbsp;" : name) + "</td>" + "<td>" + StringUtils.formatPercent(status.mapProgress(), 2) + ServletUtil.percentageGraph(status.mapProgress() * 100.0f, 80) + "</td><td>" + desiredMaps + "</td><td>" + completedMaps + "</td><td>" + StringUtils.formatPercent(status.reduceProgress(), 2) + ServletUtil.percentageGraph(status.reduceProgress() * 100.0f, 80) + "</td><td>" + desiredReduces + "</td><td> " + completedReduces + "</td><td>" + schedulingInfo + "</td></tr>\n");
                ++rowId;
            }
            if (isModifiable) {
                sb.append("</form>\n");
            }
        } else {
            sb.append("<tr><td align=\"center\" colspan=\"8\"><i>none</i></td></tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }
}

