/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.LongWritable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.FileSplit;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.LineRecordReader;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.RecordReader;
import java.io.IOException;

public class KeyValueLineRecordReader
implements RecordReader<Text, Text> {
    private final LineRecordReader lineRecordReader;
    private byte separator = (byte)9;
    private LongWritable dummyKey;
    private Text innerValue;

    public Class getKeyClass() {
        return Text.class;
    }

    @Override
    public Text createKey() {
        return new Text();
    }

    @Override
    public Text createValue() {
        return new Text();
    }

    public KeyValueLineRecordReader(Configuration job, FileSplit split) throws IOException {
        this.lineRecordReader = new LineRecordReader(job, split);
        this.dummyKey = this.lineRecordReader.createKey();
        this.innerValue = this.lineRecordReader.createValue();
        String sepStr = job.get("key.value.separator.in.input.line", "\t");
        this.separator = (byte)sepStr.charAt(0);
    }

    public static int findSeparator(byte[] utf, int start, int length, byte sep) {
        for (int i = start; i < start + length; ++i) {
            if (utf[i] != sep) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized boolean next(Text key, Text value) throws IOException {
        Text tKey = key;
        Text tValue = value;
        byte[] line = null;
        int lineLen = -1;
        if (!this.lineRecordReader.next(this.dummyKey, this.innerValue)) {
            return false;
        }
        line = this.innerValue.getBytes();
        lineLen = this.innerValue.getLength();
        if (line == null) {
            return false;
        }
        int pos = KeyValueLineRecordReader.findSeparator(line, 0, lineLen, this.separator);
        if (pos == -1) {
            tKey.set(line, 0, lineLen);
            tValue.set("");
        } else {
            int keyLen = pos;
            byte[] keyBytes = new byte[keyLen];
            System.arraycopy(line, 0, keyBytes, 0, keyLen);
            int valLen = lineLen - keyLen - 1;
            byte[] valBytes = new byte[valLen];
            System.arraycopy(line, pos + 1, valBytes, 0, valLen);
            tKey.set(keyBytes);
            tValue.set(valBytes);
        }
        return true;
    }

    @Override
    public float getProgress() {
        return this.lineRecordReader.getProgress();
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.lineRecordReader.getPos();
    }

    @Override
    public synchronized void close() throws IOException {
        this.lineRecordReader.close();
    }
}

