/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.LocalDirAllocator;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskTracker;
import java.io.IOException;

class MapOutputFile {
    private JobConf conf;
    private JobID jobId;
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");

    MapOutputFile() {
    }

    MapOutputFile(JobID jobId) {
        this.jobId = jobId;
    }

    public Path getOutputFile(TaskAttemptID mapTaskId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), mapTaskId.toString()) + "/file.out", this.conf);
    }

    public Path getOutputFileForWrite(TaskAttemptID mapTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), mapTaskId.toString()) + "/file.out", size, this.conf);
    }

    public Path getOutputIndexFile(TaskAttemptID mapTaskId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), mapTaskId.toString()) + "/file.out.index", this.conf);
    }

    public Path getOutputIndexFileForWrite(TaskAttemptID mapTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), mapTaskId.toString()) + "/file.out.index", size, this.conf);
    }

    public Path getSpillFile(TaskAttemptID mapTaskId, int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), mapTaskId.toString()) + "/spill" + spillNumber + ".out", this.conf);
    }

    public Path getSpillFileForWrite(TaskAttemptID mapTaskId, int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), mapTaskId.toString()) + "/spill" + spillNumber + ".out", size, this.conf);
    }

    public Path getSpillIndexFile(TaskAttemptID mapTaskId, int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), mapTaskId.toString()) + "/spill" + spillNumber + ".out.index", this.conf);
    }

    public Path getSpillIndexFileForWrite(TaskAttemptID mapTaskId, int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), mapTaskId.toString()) + "/spill" + spillNumber + ".out.index", size, this.conf);
    }

    public Path getInputFile(int mapId, TaskAttemptID reduceTaskId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), reduceTaskId.toString()) + "/map_" + mapId + ".out", this.conf);
    }

    public Path getInputFileForWrite(TaskID mapId, TaskAttemptID reduceTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), reduceTaskId.toString()) + "/map_" + mapId.getId() + ".out", size, this.conf);
    }

    public void removeAll(TaskAttemptID taskId) throws IOException {
        this.conf.deleteLocalFiles(TaskTracker.getIntermediateOutputDir(this.jobId.toString(), taskId.toString()));
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
    }

    public void setJobId(JobID jobId) {
        this.jobId = jobId;
    }
}

