/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskTracker;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ProcfsBasedProcessTree;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class TaskMemoryManagerThread
extends Thread {
    private static Log LOG = LogFactory.getLog(TaskMemoryManagerThread.class);
    private TaskTracker taskTracker;
    private long monitoringInterval;
    private long sleepTimeBeforeSigKill;
    private long maxMemoryAllowedForAllTasks;
    private Map<TaskAttemptID, ProcessTreeInfo> processTreeInfoMap;
    private Map<TaskAttemptID, ProcessTreeInfo> tasksToBeAdded;
    private List<TaskAttemptID> tasksToBeRemoved;

    public TaskMemoryManagerThread(TaskTracker taskTracker) {
        this(taskTracker.getTotalMemoryAllottedForTasksOnTT() * 1024L * 1024L, taskTracker.getJobConf().getLong("mapred.tasktracker.taskmemorymanager.monitoring-interval", 5000L), taskTracker.getJobConf().getLong("mapred.tasktracker.procfsbasedprocesstree.sleeptime-before-sigkill", 5000L));
        this.taskTracker = taskTracker;
    }

    TaskMemoryManagerThread(long maxMemoryAllowedForAllTasks, long monitoringInterval, long sleepTimeBeforeSigKill) {
        this.setName(this.getClass().getName());
        this.processTreeInfoMap = new HashMap<TaskAttemptID, ProcessTreeInfo>();
        this.tasksToBeAdded = new HashMap<TaskAttemptID, ProcessTreeInfo>();
        this.tasksToBeRemoved = new ArrayList<TaskAttemptID>();
        this.maxMemoryAllowedForAllTasks = maxMemoryAllowedForAllTasks;
        this.monitoringInterval = monitoringInterval;
        this.sleepTimeBeforeSigKill = sleepTimeBeforeSigKill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(TaskAttemptID tid, long memLimit, String pidFile) {
        Map<TaskAttemptID, ProcessTreeInfo> map = this.tasksToBeAdded;
        synchronized (map) {
            LOG.debug("Tracking ProcessTree " + tid + " for the first time");
            ProcessTreeInfo ptInfo = new ProcessTreeInfo(tid, null, null, memLimit, this.sleepTimeBeforeSigKill, pidFile);
            this.tasksToBeAdded.put(tid, ptInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(TaskAttemptID tid) {
        List<TaskAttemptID> list = this.tasksToBeRemoved;
        synchronized (list) {
            this.tasksToBeRemoved.add(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("Starting thread: " + this.getClass());
        while (true) {
            List<TaskAttemptID> tmp;
            if (LOG.isDebugEnabled()) {
                tmp = new StringBuffer("[ ");
                for (ProcessTreeInfo p : this.processTreeInfoMap.values()) {
                    ((StringBuffer)((Object)tmp)).append(p.getPID());
                    ((StringBuffer)((Object)tmp)).append(" ");
                }
                LOG.debug("Current ProcessTree list : " + ((StringBuffer)((Object)tmp)).substring(0, ((StringBuffer)((Object)tmp)).length()) + "]");
            }
            tmp = this.tasksToBeAdded;
            synchronized (tmp) {
                this.processTreeInfoMap.putAll(this.tasksToBeAdded);
                this.tasksToBeAdded.clear();
            }
            tmp = this.tasksToBeRemoved;
            synchronized (tmp) {
                for (TaskAttemptID tid : this.tasksToBeRemoved) {
                    this.processTreeInfoMap.remove(tid);
                }
                this.tasksToBeRemoved.clear();
            }
            long memoryStillInUsage = 0L;
            Iterator<Map.Entry<TaskAttemptID, ProcessTreeInfo>> it = this.processTreeInfoMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TaskAttemptID, ProcessTreeInfo> entry = it.next();
                TaskAttemptID tid = entry.getKey();
                ProcessTreeInfo ptInfo = entry.getValue();
                try {
                    String pId = ptInfo.getPID();
                    if (pId == null && (pId = this.getPid(ptInfo.pidFile)) != null) {
                        ProcfsBasedProcessTree pt = new ProcfsBasedProcessTree(pId);
                        LOG.debug("Tracking ProcessTree " + pId + " for the first time");
                        ptInfo.setPid(pId);
                        ptInfo.setProcessTree(pt);
                    }
                    if (pId == null) continue;
                    LOG.debug("Constructing ProcessTree for : PID = " + pId + " TID = " + tid);
                    ProcfsBasedProcessTree pTree = ptInfo.getProcessTree();
                    pTree = pTree.getProcessTree();
                    ptInfo.setProcessTree(pTree);
                    long currentMemUsage = pTree.getCumulativeVmem();
                    long curMemUsageOfAgedProcesses = pTree.getCumulativeVmem(1);
                    long limit = ptInfo.getMemLimit();
                    LOG.info("Memory usage of ProcessTree " + pId + " :" + currentMemUsage + "bytes. Limit : " + limit + "bytes");
                    if (this.isProcessTreeOverLimit(tid.toString(), currentMemUsage, curMemUsageOfAgedProcesses, limit)) {
                        String msg = "TaskTree [pid=" + pId + ",tipID=" + tid + "] is running beyond memory-limits. Current usage : " + currentMemUsage + "bytes. Limit : " + limit + "bytes. Killing task.";
                        LOG.warn(msg);
                        this.taskTracker.cleanUpOverMemoryTask(tid, true, msg);
                        pTree.destroy();
                        it.remove();
                        LOG.info("Removed ProcessTree with root " + pId);
                        continue;
                    }
                    memoryStillInUsage += currentMemUsage;
                }
                catch (Exception e) {
                    LOG.warn("Uncaught exception in TaskMemoryManager while managing memory of " + tid + " : " + StringUtils.stringifyException(e));
                }
            }
            if (memoryStillInUsage > this.maxMemoryAllowedForAllTasks) {
                LOG.warn("The total memory in usage " + memoryStillInUsage + " is still overflowing TTs limits " + this.maxMemoryAllowedForAllTasks + ". Trying to kill a few tasks with the least progress.");
                this.killTasksWithLeastProgress(memoryStillInUsage);
            }
            try {
                LOG.debug(this.getClass() + " : Sleeping for " + this.monitoringInterval + " ms");
                Thread.sleep(this.monitoringInterval);
            }
            catch (InterruptedException ie) {
                LOG.warn(this.getClass() + " interrupted. Finishing the thread and returning.");
                return;
            }
        }
    }

    boolean isProcessTreeOverLimit(String tId, long currentMemUsage, long curMemUsageOfAgedProcesses, long limit) {
        boolean isOverLimit = false;
        if (currentMemUsage > 2L * limit) {
            LOG.warn("Process tree for task: " + tId + " running over twice " + "the configured limit. Limit=" + limit + ", current usage = " + currentMemUsage);
            isOverLimit = true;
        } else if (curMemUsageOfAgedProcesses > limit) {
            LOG.warn("Process tree for task: " + tId + " has processes older than 1 " + "iteration running over the configured limit. Limit=" + limit + ", current usage = " + curMemUsageOfAgedProcesses);
            isOverLimit = true;
        }
        return isOverLimit;
    }

    boolean isProcessTreeOverLimit(ProcfsBasedProcessTree pTree, String tId, long limit) {
        long currentMemUsage = pTree.getCumulativeVmem();
        long curMemUsageOfAgedProcesses = pTree.getCumulativeVmem(1);
        return this.isProcessTreeOverLimit(tId, currentMemUsage, curMemUsageOfAgedProcesses, limit);
    }

    private void killTasksWithLeastProgress(long memoryStillInUsage) {
        TaskTracker.TaskInProgress task;
        ArrayList<TaskAttemptID> tasksToKill = new ArrayList<TaskAttemptID>();
        ArrayList<TaskAttemptID> tasksToExclude = new ArrayList<TaskAttemptID>();
        while (memoryStillInUsage > this.maxMemoryAllowedForAllTasks && (task = this.taskTracker.findTaskToKill(tasksToExclude)) != null) {
            TaskAttemptID tid = task.getTask().getTaskID();
            if (this.processTreeInfoMap.containsKey(tid)) {
                ProcessTreeInfo ptInfo = this.processTreeInfoMap.get(tid);
                ProcfsBasedProcessTree pTree = ptInfo.getProcessTree();
                memoryStillInUsage -= pTree.getCumulativeVmem();
                tasksToKill.add(tid);
            }
            tasksToExclude.add(tid);
        }
        if (!tasksToKill.isEmpty()) {
            for (TaskAttemptID tid : tasksToKill) {
                String msg = "Killing one of the least progress tasks - " + tid + ", as the cumulative memory usage of all the tasks on " + "the TaskTracker exceeds virtual memory limit " + this.maxMemoryAllowedForAllTasks + ".";
                LOG.warn(msg);
                this.taskTracker.cleanUpOverMemoryTask(tid, false, msg);
                ProcessTreeInfo ptInfo = this.processTreeInfoMap.get(tid);
                ProcfsBasedProcessTree pTree = ptInfo.getProcessTree();
                pTree.destroy();
                this.processTreeInfoMap.remove(tid);
                LOG.info("Removed ProcessTree with root " + ptInfo.getPID());
            }
        } else {
            LOG.info("The total memory usage is overflowing TTs limits. But found no alive task to kill for freeing memory.");
        }
    }

    private String getPid(String pidFileName) {
        if (new File(pidFileName).exists()) {
            return ProcfsBasedProcessTree.getPidFromPidFile(pidFileName);
        }
        return null;
    }

    private static class ProcessTreeInfo {
        private TaskAttemptID tid;
        private String pid;
        private ProcfsBasedProcessTree pTree;
        private long memLimit;
        private String pidFile;

        public ProcessTreeInfo(TaskAttemptID tid, String pid, ProcfsBasedProcessTree pTree, long memLimit, long sleepTimeBeforeSigKill, String pidFile) {
            this.tid = tid;
            this.pid = pid;
            this.pTree = pTree;
            if (this.pTree != null) {
                this.pTree.setSigKillInterval(sleepTimeBeforeSigKill);
            }
            this.memLimit = memLimit;
            this.pidFile = pidFile;
        }

        public TaskAttemptID getTID() {
            return this.tid;
        }

        public String getPID() {
            return this.pid;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public ProcfsBasedProcessTree getProcessTree() {
            return this.pTree;
        }

        public void setProcessTree(ProcfsBasedProcessTree pTree) {
            this.pTree = pTree;
        }

        public long getMemLimit() {
            return this.memLimit;
        }
    }
}

