/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskTracker;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskTrackerInstrumentation;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsContext;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsRecord;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsUtil;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.metrics.Updater;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.metrics.jvm.JvmMetrics;

class TaskTrackerMetricsInst
extends TaskTrackerInstrumentation
implements Updater {
    private final MetricsRecord metricsRecord;
    private int numCompletedTasks = 0;
    private int timedoutTasks = 0;
    private int tasksFailedPing = 0;

    public TaskTrackerMetricsInst(TaskTracker t) {
        super(t);
        JobConf conf = this.tt.getJobConf();
        String sessionId = conf.getSessionId();
        JvmMetrics.init("TaskTracker", sessionId);
        MetricsContext context = MetricsUtil.getContext("mapred");
        this.metricsRecord = MetricsUtil.createRecord(context, "tasktracker");
        this.metricsRecord.setTag("sessionId", sessionId);
        context.registerUpdater(this);
    }

    @Override
    public synchronized void completeTask(TaskAttemptID t) {
        ++this.numCompletedTasks;
    }

    @Override
    public synchronized void timedoutTask(TaskAttemptID t) {
        ++this.timedoutTasks;
    }

    @Override
    public synchronized void taskFailedPing(TaskAttemptID t) {
        ++this.tasksFailedPing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext unused) {
        TaskTrackerMetricsInst taskTrackerMetricsInst = this;
        synchronized (taskTrackerMetricsInst) {
            this.metricsRecord.setMetric("maps_running", this.tt.mapTotal);
            this.metricsRecord.setMetric("reduces_running", this.tt.reduceTotal);
            this.metricsRecord.setMetric("mapTaskSlots", (short)this.tt.getMaxCurrentMapTasks());
            this.metricsRecord.setMetric("reduceTaskSlots", (short)this.tt.getMaxCurrentReduceTasks());
            this.metricsRecord.incrMetric("tasks_completed", this.numCompletedTasks);
            this.metricsRecord.incrMetric("tasks_failed_timeout", this.timedoutTasks);
            this.metricsRecord.incrMetric("tasks_failed_ping", this.tasksFailedPing);
            this.numCompletedTasks = 0;
            this.timedoutTasks = 0;
            this.tasksFailedPing = 0;
        }
        this.metricsRecord.update();
    }
}

