/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.Mapper;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.OutputCollector;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.Reporter;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.TaggedInputSplit;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.IOException;

public class DelegatingMapper<K1, V1, K2, V2>
implements Mapper<K1, V1, K2, V2> {
    private JobConf conf;
    private Mapper<K1, V1, K2, V2> mapper;

    @Override
    public void map(K1 key, V1 value, OutputCollector<K2, V2> outputCollector, Reporter reporter) throws IOException {
        if (this.mapper == null) {
            TaggedInputSplit inputSplit = (TaggedInputSplit)reporter.getInputSplit();
            this.mapper = ReflectionUtils.newInstance(inputSplit.getMapperClass(), this.conf);
        }
        this.mapper.map(key, value, outputCollector, reporter);
    }

    @Override
    public void configure(JobConf conf) {
        this.conf = conf;
    }

    @Override
    public void close() throws IOException {
        if (this.mapper != null) {
            this.mapper.close();
        }
    }
}

