/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparator;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConfigurable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.KeyFieldHelper;
import java.util.List;

public class KeyFieldBasedComparator<K, V>
extends WritableComparator
implements JobConfigurable {
    private KeyFieldHelper keyFieldHelper = new KeyFieldHelper();
    private static final byte NEGATIVE = 45;
    private static final byte ZERO = 48;
    private static final byte DECIMAL = 46;

    @Override
    public void configure(JobConf job) {
        String option = job.getKeyFieldComparatorOption();
        String keyFieldSeparator = job.get("map.output.key.field.separator", "\t");
        this.keyFieldHelper.setKeyFieldSeparator(keyFieldSeparator);
        this.keyFieldHelper.parseOption(option);
    }

    public KeyFieldBasedComparator() {
        super(Text.class);
    }

    @Override
    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int n1 = WritableUtils.decodeVIntSize(b1[s1]);
        int n2 = WritableUtils.decodeVIntSize(b2[s2]);
        List<KeyFieldHelper.KeyDescription> allKeySpecs = this.keyFieldHelper.keySpecs();
        if (allKeySpecs.size() == 0) {
            return KeyFieldBasedComparator.compareBytes(b1, s1 + n1, l1 - n1, b2, s2 + n2, l2 - n2);
        }
        int[] lengthIndicesFirst = this.keyFieldHelper.getWordLengths(b1, s1 + n1, s1 + l1);
        int[] lengthIndicesSecond = this.keyFieldHelper.getWordLengths(b2, s2 + n2, s2 + l2);
        for (KeyFieldHelper.KeyDescription keySpec : allKeySpecs) {
            int endCharSecond;
            int startCharSecond;
            int endCharFirst;
            int startCharFirst = this.keyFieldHelper.getStartOffset(b1, s1 + n1, s1 + l1, lengthIndicesFirst, keySpec);
            int result = this.compareByteSequence(b1, startCharFirst, endCharFirst = this.keyFieldHelper.getEndOffset(b1, s1 + n1, s1 + l1, lengthIndicesFirst, keySpec), b2, startCharSecond = this.keyFieldHelper.getStartOffset(b2, s2 + n2, s2 + l2, lengthIndicesSecond, keySpec), endCharSecond = this.keyFieldHelper.getEndOffset(b2, s2 + n2, s2 + l2, lengthIndicesSecond, keySpec), keySpec);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private int compareByteSequence(byte[] first, int start1, int end1, byte[] second, int start2, int end2, KeyFieldHelper.KeyDescription key) {
        if (start1 == -1) {
            if (key.reverse) {
                return 1;
            }
            return -1;
        }
        if (start2 == -1) {
            if (key.reverse) {
                return -1;
            }
            return 1;
        }
        int compareResult = 0;
        if (!key.numeric) {
            compareResult = KeyFieldBasedComparator.compareBytes(first, start1, end1 - start1 + 1, second, start2, end2 - start2 + 1);
        }
        if (key.numeric) {
            compareResult = this.numericalCompare(first, start1, end1, second, start2, end2);
        }
        if (key.reverse) {
            return -compareResult;
        }
        return compareResult;
    }

    private int numericalCompare(byte[] a, int start1, int end1, byte[] b, int start2, int end2) {
        int i = start1;
        int j = start2;
        int mul = 1;
        byte first_a = a[i];
        byte first_b = b[j];
        if (first_a == 45) {
            if (first_b != 45) {
                return this.oneNegativeCompare(a, start1 + 1, end1, b, start2, end2);
            }
            ++i;
        }
        if (first_b == 45) {
            if (first_a != 45) {
                return -this.oneNegativeCompare(b, start2 + 1, end2, a, start1, end1);
            }
            ++j;
        }
        if (first_b == 45 && first_a == 45) {
            mul = -1;
        }
        while (i <= end1 && a[i] == 48) {
            ++i;
        }
        while (j <= end2 && b[j] == 48) {
            ++j;
        }
        while (i <= end1 && j <= end2 && this.isdigit(a[i]) && a[i] == b[j]) {
            ++i;
            ++j;
        }
        if (i <= end1) {
            first_a = a[i];
        }
        if (j <= end2) {
            first_b = b[j];
        }
        int firstResult = first_a - first_b;
        if (first_a == 46 && (!this.isdigit(first_b) || j > end2) || first_b == 46 && (!this.isdigit(first_a) || i > end1)) {
            return mul < 0 ? -this.decimalCompare(a, i, end1, b, j, end2) : this.decimalCompare(a, i, end1, b, j, end2);
        }
        int numRemainDigits_a = 0;
        int numRemainDigits_b = 0;
        while (i <= end1 && this.isdigit(a[i++])) {
            ++numRemainDigits_a;
        }
        while (j <= end2 && this.isdigit(b[j++])) {
            ++numRemainDigits_b;
        }
        int ret = numRemainDigits_a - numRemainDigits_b;
        if (ret == 0) {
            return mul < 0 ? -firstResult : firstResult;
        }
        return mul < 0 ? -ret : ret;
    }

    private boolean isdigit(byte b) {
        return 48 <= b && b <= 57;
    }

    private int decimalCompare(byte[] a, int i, int end1, byte[] b, int j, int end2) {
        if (i > end1) {
            return -this.decimalCompare1(b, ++j, end2);
        }
        if (j > end2) {
            return this.decimalCompare1(a, ++i, end1);
        }
        if (a[i] == 46 && b[j] == 46) {
            while (i <= end1 && j <= end2) {
                if (a[i] != b[j]) {
                    if (this.isdigit(a[i]) && this.isdigit(b[j])) {
                        return a[i] - b[j];
                    }
                    if (this.isdigit(a[i])) {
                        return 1;
                    }
                    if (this.isdigit(b[j])) {
                        return -1;
                    }
                    return 0;
                }
                ++i;
                ++j;
            }
            if (i > end1 && j > end2) {
                return 0;
            }
            if (i > end1) {
                return -this.decimalCompare1(b, j, end2);
            }
            if (j > end2) {
                return this.decimalCompare1(a, i, end1);
            }
        } else {
            if (a[i] == 46) {
                return this.decimalCompare1(a, ++i, end1);
            }
            if (b[j] == 46) {
                return -this.decimalCompare1(b, ++j, end2);
            }
        }
        return 0;
    }

    private int decimalCompare1(byte[] a, int i, int end) {
        while (i <= end) {
            if (a[i] == 48) {
                ++i;
                continue;
            }
            if (this.isdigit(a[i])) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private int oneNegativeCompare(byte[] a, int start1, int end1, byte[] b, int start2, int end2) {
        if (!this.isZero(a, start1, end1)) {
            return -1;
        }
        if (!this.isZero(b, start2, end2)) {
            return -1;
        }
        return 0;
    }

    private boolean isZero(byte[] a, int start, int end) {
        int i;
        for (i = start; i <= end; ++i) {
            if (a[i] == 48) continue;
            if (a[i] == 46 || !this.isdigit(a[i])) break;
            return false;
        }
        if (i != end + 1 && a[i++] == 46) {
            while (i <= end) {
                if (a[i] != 48) {
                    if (!this.isdigit(a[i])) break;
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

