/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataInputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.LongWritable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.FileInputFormat;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.FileSplit;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.InputSplit;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConfigurable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.LineRecordReader;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.RecordReader;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.Reporter;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class NLineInputFormat
extends FileInputFormat<LongWritable, Text>
implements JobConfigurable {
    private int N = 1;

    @Override
    public RecordReader<LongWritable, Text> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        return new LineRecordReader(job, (FileSplit)genericSplit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (FileStatus status : this.listStatus(job)) {
            Path fileName = status.getPath();
            if (status.isDir()) {
                throw new IOException("Not a file: " + fileName);
            }
            FileSystem fs = fileName.getFileSystem(job);
            LineReader lr = null;
            try {
                FSDataInputStream in = fs.open(fileName);
                lr = new LineReader((InputStream)in, job);
                Text line = new Text();
                int numLines = 0;
                long begin = 0L;
                long length = 0L;
                int num = -1;
                while ((num = lr.readLine(line)) > 0) {
                    length += (long)num;
                    if (++numLines != this.N) continue;
                    splits.add(new FileSplit(fileName, begin, length, new String[0]));
                    begin += length;
                    length = 0L;
                    numLines = 0;
                }
                if (numLines == 0) continue;
                splits.add(new FileSplit(fileName, begin, length, new String[0]));
            }
            finally {
                if (lr != null) {
                    lr.close();
                }
            }
        }
        return splits.toArray(new FileSplit[splits.size()]);
    }

    @Override
    public void configure(JobConf conf) {
        this.N = conf.getInt("mapred.line.input.format.linespermap", 1);
    }
}

