/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.pipes;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.filecache.DistributedCache;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileUtil;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.FloatWritable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.NullWritable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.OutputCollector;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.RecordReader;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.Reporter;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskLog;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.pipes.BinaryProtocol;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.pipes.DownwardProtocol;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.pipes.OutputHandler;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Application<K1 extends WritableComparable, V1 extends Writable, K2 extends WritableComparable, V2 extends Writable> {
    private static final Log LOG = LogFactory.getLog(Application.class.getName());
    private ServerSocket serverSocket = new ServerSocket(0);
    private Process process;
    private Socket clientSocket;
    private OutputHandler<K2, V2> handler;
    private DownwardProtocol<K1, V1> downlink;
    static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");

    Application(JobConf conf, RecordReader<FloatWritable, NullWritable> recordReader, OutputCollector<K2, V2> output, Reporter reporter, Class<? extends K2> outputKeyClass, Class<? extends V2> outputValueClass) throws IOException, InterruptedException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("TMPDIR", System.getProperty("java.io.tmpdir"));
        env.put("hadoop.pipes.command.port", Integer.toString(this.serverSocket.getLocalPort()));
        List<String> cmd = new ArrayList<String>();
        String interpretor = conf.get("hadoop.pipes.executable.interpretor");
        if (interpretor != null) {
            cmd.add(interpretor);
        }
        String executable = DistributedCache.getLocalCacheFiles(conf)[0].toString();
        FileUtil.chmod(executable, "a+x");
        cmd.add(executable);
        TaskAttemptID taskid = TaskAttemptID.forName(conf.get("mapred.task.id"));
        File stdout = TaskLog.getTaskLogFile(taskid, TaskLog.LogName.STDOUT);
        File stderr = TaskLog.getTaskLogFile(taskid, TaskLog.LogName.STDERR);
        long logLength = TaskLog.getTaskLogLength(conf);
        cmd = TaskLog.captureOutAndError(cmd, stdout, stderr, logLength);
        this.process = Application.runClient(cmd, env);
        this.clientSocket = this.serverSocket.accept();
        this.handler = new OutputHandler<K2, V2>(output, reporter, recordReader);
        WritableComparable outputKey = (WritableComparable)ReflectionUtils.newInstance(outputKeyClass, conf);
        Writable outputValue = (Writable)ReflectionUtils.newInstance(outputValueClass, conf);
        this.downlink = new BinaryProtocol(this.clientSocket, this.handler, outputKey, outputValue, conf);
        this.downlink.start();
        this.downlink.setJobConf(conf);
    }

    DownwardProtocol<K1, V1> getDownlink() {
        return this.downlink;
    }

    boolean waitForFinish() throws Throwable {
        this.downlink.flush();
        return this.handler.waitForFinish();
    }

    void abort(Throwable t) throws IOException {
        LOG.info("Aborting because of " + StringUtils.stringifyException(t));
        try {
            this.downlink.abort();
            this.downlink.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.handler.waitForFinish();
        }
        catch (Throwable ignored) {
            this.process.destroy();
        }
        IOException wrapper = new IOException("pipe child exception");
        wrapper.initCause(t);
        throw wrapper;
    }

    void cleanup() throws IOException {
        this.serverSocket.close();
        try {
            this.downlink.close();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    static Process runClient(List<String> command, Map<String, String> env) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command);
        if (env != null) {
            builder.environment().putAll(env);
        }
        Process result = builder.start();
        return result;
    }
}

