/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.lib.input;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.BlockLocation;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.PathFilter;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputFormat;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputSplit;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.Job;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.JobContext;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.lib.input.FileSplit;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class FileInputFormat<K, V>
extends InputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(FileInputFormat.class);
    private static final double SPLIT_SLOP = 1.1;
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        @Override
        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    protected long getFormatMinSplitSize() {
        return 1L;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return true;
    }

    public static void setInputPathFilter(Job job, Class<? extends PathFilter> filter) {
        job.getConfiguration().setClass("mapred.input.pathFilter.class", filter, PathFilter.class);
    }

    public static void setMinInputSplitSize(Job job, long size) {
        job.getConfiguration().setLong("mapred.min.split.size", size);
    }

    public static long getMinSplitSize(JobContext job) {
        return job.getConfiguration().getLong("mapred.min.split.size", 1L);
    }

    public static void setMaxInputSplitSize(Job job, long size) {
        job.getConfiguration().setLong("mapred.max.split.size", size);
    }

    public static long getMaxSplitSize(JobContext context) {
        return context.getConfiguration().getLong("mapred.max.split.size", Long.MAX_VALUE);
    }

    public static PathFilter getInputPathFilter(JobContext context) {
        Configuration conf = context.getConfiguration();
        Class<PathFilter> filterClass = conf.getClass("mapred.input.pathFilter.class", null, PathFilter.class);
        return filterClass != null ? ReflectionUtils.newInstance(filterClass, conf) : null;
    }

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        Path[] dirs = FileInputFormat.getInputPaths(job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<IOException> errors = new ArrayList<IOException>();
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(hiddenFileFilter);
        PathFilter jobFilter = FileInputFormat.getInputPathFilter(job);
        if (jobFilter != null) {
            filters.add(jobFilter);
        }
        MultiPathFilter inputFilter = new MultiPathFilter(filters);
        for (int i = 0; i < dirs.length; ++i) {
            Path p = dirs[i];
            FileSystem fs = p.getFileSystem(job.getConfiguration());
            FileStatus[] matches = fs.globStatus(p, inputFilter);
            if (matches == null) {
                errors.add(new IOException("Input path does not exist: " + p));
                continue;
            }
            if (matches.length == 0) {
                errors.add(new IOException("Input Pattern " + p + " matches 0 files"));
                continue;
            }
            for (FileStatus globStat : matches) {
                if (globStat.isDir()) {
                    for (FileStatus stat : fs.listStatus(globStat.getPath(), (PathFilter)inputFilter)) {
                        result.add(stat);
                    }
                    continue;
                }
                result.add(globStat);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidInputException(errors);
        }
        LOG.info("Total input paths to process : " + result.size());
        return result;
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        long minSize = Math.max(this.getFormatMinSplitSize(), FileInputFormat.getMinSplitSize(job));
        long maxSize = FileInputFormat.getMaxSplitSize(job);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (FileStatus file : this.listStatus(job)) {
            Path path = file.getPath();
            FileSystem fs = path.getFileSystem(job.getConfiguration());
            long length = file.getLen();
            BlockLocation[] blkLocations = fs.getFileBlockLocations(file, 0L, length);
            if (length != 0L && this.isSplitable(job, path)) {
                long blockSize = file.getBlockSize();
                long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    int blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                    splits.add(new FileSplit(path, length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts()));
                    bytesRemaining -= splitSize;
                }
                if (bytesRemaining == 0L) continue;
                splits.add(new FileSplit(path, length - bytesRemaining, bytesRemaining, blkLocations[blkLocations.length - 1].getHosts()));
                continue;
            }
            if (length != 0L) {
                splits.add(new FileSplit(path, 0L, length, blkLocations[0].getHosts()));
                continue;
            }
            splits.add(new FileSplit(path, 0L, length, new String[0]));
        }
        LOG.debug("Total # of splits: " + splits.size());
        return splits;
    }

    protected long computeSplitSize(long blockSize, long minSize, long maxSize) {
        return Math.max(minSize, Math.min(maxSize, blockSize));
    }

    protected int getBlockIndex(BlockLocation[] blkLocations, long offset) {
        for (int i = 0; i < blkLocations.length; ++i) {
            if (blkLocations[i].getOffset() > offset || offset >= blkLocations[i].getOffset() + blkLocations[i].getLength()) continue;
            return i;
        }
        BlockLocation last = blkLocations[blkLocations.length - 1];
        long fileLength = last.getOffset() + last.getLength() - 1L;
        throw new IllegalArgumentException("Offset " + offset + " is outside of file (0.." + fileLength + ")");
    }

    public static void setInputPaths(Job job, String commaSeparatedPaths) throws IOException {
        FileInputFormat.setInputPaths(job, StringUtils.stringToPath(FileInputFormat.getPathStrings(commaSeparatedPaths)));
    }

    public static void addInputPaths(Job job, String commaSeparatedPaths) throws IOException {
        for (String str : FileInputFormat.getPathStrings(commaSeparatedPaths)) {
            FileInputFormat.addInputPath(job, new Path(str));
        }
    }

    public static void setInputPaths(Job job, Path ... inputPaths) throws IOException {
        Configuration conf = job.getConfiguration();
        FileSystem fs = FileSystem.get(conf);
        Path path = inputPaths[0].makeQualified(fs);
        StringBuffer str = new StringBuffer(StringUtils.escapeString(path.toString()));
        for (int i = 1; i < inputPaths.length; ++i) {
            str.append(",");
            path = inputPaths[i].makeQualified(fs);
            str.append(StringUtils.escapeString(path.toString()));
        }
        conf.set("mapred.input.dir", str.toString());
    }

    public static void addInputPath(Job job, Path path) throws IOException {
        Configuration conf = job.getConfiguration();
        FileSystem fs = FileSystem.get(conf);
        path = path.makeQualified(fs);
        String dirStr = StringUtils.escapeString(path.toString());
        String dirs = conf.get("mapred.input.dir");
        conf.set("mapred.input.dir", dirs == null ? dirStr : dirs + "," + dirStr);
    }

    private static String[] getPathStrings(String commaSeparatedPaths) {
        int length = commaSeparatedPaths.length();
        int curlyOpen = 0;
        int pathStart = 0;
        boolean globPattern = false;
        ArrayList<String> pathStrings = new ArrayList<String>();
        block5: for (int i = 0; i < length; ++i) {
            char ch = commaSeparatedPaths.charAt(i);
            switch (ch) {
                case '{': {
                    ++curlyOpen;
                    if (globPattern) continue block5;
                    globPattern = true;
                    continue block5;
                }
                case '}': {
                    if (--curlyOpen != 0 || !globPattern) continue block5;
                    globPattern = false;
                    continue block5;
                }
                case ',': {
                    if (globPattern) continue block5;
                    pathStrings.add(commaSeparatedPaths.substring(pathStart, i));
                    pathStart = i + 1;
                }
            }
        }
        pathStrings.add(commaSeparatedPaths.substring(pathStart, length));
        return pathStrings.toArray(new String[0]);
    }

    public static Path[] getInputPaths(JobContext context) {
        String dirs = context.getConfiguration().get("mapred.input.dir", "");
        String[] list = StringUtils.split(dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString(list[i]));
        }
        return result;
    }

    private static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        @Override
        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (filter.accept(path)) continue;
                return false;
            }
            return true;
        }
    }
}

