/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.record;

import java.io.UnsupportedEncodingException;

public class Buffer
implements Comparable,
Cloneable {
    private int count;
    private byte[] bytes = null;

    public Buffer() {
        this.count = 0;
    }

    public Buffer(byte[] bytes) {
        this.bytes = bytes;
        this.count = bytes == null ? 0 : bytes.length;
    }

    public Buffer(byte[] bytes, int offset, int length) {
        this.copy(bytes, offset, length);
    }

    public void set(byte[] bytes) {
        this.count = bytes == null ? 0 : bytes.length;
        this.bytes = bytes;
    }

    public final void copy(byte[] bytes, int offset, int length) {
        if (this.bytes == null || this.bytes.length < length) {
            this.bytes = new byte[length];
        }
        System.arraycopy(bytes, offset, this.bytes, 0, length);
        this.count = length;
    }

    public byte[] get() {
        if (this.bytes == null) {
            this.bytes = new byte[0];
        }
        return this.bytes;
    }

    public int getCount() {
        return this.count;
    }

    public int getCapacity() {
        return this.get().length;
    }

    public void setCapacity(int newCapacity) {
        if (newCapacity < 0) {
            throw new IllegalArgumentException("Invalid capacity argument " + newCapacity);
        }
        if (newCapacity == 0) {
            this.bytes = null;
            this.count = 0;
            return;
        }
        if (newCapacity != this.getCapacity()) {
            byte[] data = new byte[newCapacity];
            if (newCapacity < this.count) {
                this.count = newCapacity;
            }
            if (this.count != 0) {
                System.arraycopy(this.get(), 0, data, 0, this.count);
            }
            this.bytes = data;
        }
    }

    public void reset() {
        this.setCapacity(0);
    }

    public void truncate() {
        this.setCapacity(this.count);
    }

    public void append(byte[] bytes, int offset, int length) {
        this.setCapacity(this.count + length);
        System.arraycopy(bytes, offset, this.get(), this.count, length);
        this.count += length;
    }

    public void append(byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    public int hashCode() {
        int hash = 1;
        byte[] b = this.get();
        for (int i = 0; i < this.count; ++i) {
            hash = 31 * hash + b[i];
        }
        return hash;
    }

    public int compareTo(Object other) {
        Buffer right = (Buffer)other;
        byte[] lb = this.get();
        byte[] rb = right.get();
        for (int i = 0; i < this.count && i < right.count; ++i) {
            int a = lb[i] & 0xFF;
            int b = rb[i] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return this.count - right.count;
    }

    public boolean equals(Object other) {
        if (other instanceof Buffer && this != other) {
            return this.compareTo(other) == 0;
        }
        return this == other;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(2 * this.count);
        for (int idx = 0; idx < this.count; ++idx) {
            sb.append(Character.forDigit((this.bytes[idx] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(this.bytes[idx] & 0xF, 16));
        }
        return sb.toString();
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.get(), 0, this.getCount(), charsetName);
    }

    public Object clone() throws CloneNotSupportedException {
        Buffer result = (Buffer)super.clone();
        result.copy(this.get(), 0, this.getCount());
        return result;
    }
}

