/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.auth;

import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.AnonymousAuthenticationProviderImpl;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.CustomAuthenticationProviderImpl;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.LdapAuthenticationProviderImpl;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.PamAuthenticationProviderImpl;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.PasswdAuthenticationProvider;
import javax.security.sasl.AuthenticationException;

public class AuthenticationProviderFactory {
    private AuthenticationProviderFactory() {
    }

    public static PasswdAuthenticationProvider getAuthenticationProvider(AuthMethods authMethod) throws AuthenticationException {
        if (authMethod.equals((Object)AuthMethods.LDAP)) {
            return new LdapAuthenticationProviderImpl();
        }
        if (authMethod.equals((Object)AuthMethods.PAM)) {
            return new PamAuthenticationProviderImpl();
        }
        if (authMethod.equals((Object)AuthMethods.CUSTOM)) {
            return new CustomAuthenticationProviderImpl();
        }
        if (authMethod.equals((Object)AuthMethods.NONE)) {
            return new AnonymousAuthenticationProviderImpl();
        }
        throw new AuthenticationException("Unsupported authentication method");
    }

    public static enum AuthMethods {
        LDAP("LDAP"),
        PAM("PAM"),
        CUSTOM("CUSTOM"),
        NONE("NONE");

        String authMethod;

        private AuthMethods(String authMethod) {
            this.authMethod = authMethod;
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public static AuthMethods getValidAuthMethod(String authMethodStr) throws AuthenticationException {
            for (AuthMethods auth : AuthMethods.values()) {
                if (!authMethodStr.equals(auth.getAuthMethod())) continue;
                return auth;
            }
            throw new AuthenticationException("Not a valid authentication method");
        }
    }
}

