/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.auth;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.shims.HadoopShims;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.shims.ShimLoader;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.security.UserGroupInformation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.session.SessionManager;
import io.trino.hive.jdbc.$internal.org.apache.thrift.TException;
import io.trino.hive.jdbc.$internal.org.apache.thrift.TProcessor;
import io.trino.hive.jdbc.$internal.org.apache.thrift.protocol.TProtocol;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;

public class HttpCLIServiceUGIProcessor
implements TProcessor {
    private final TProcessor underlyingProcessor;
    private final HadoopShims shim;

    public HttpCLIServiceUGIProcessor(TProcessor underlyingProcessor) {
        this.underlyingProcessor = underlyingProcessor;
        this.shim = ShimLoader.getHadoopShims();
    }

    @Override
    public boolean process(final TProtocol in, final TProtocol out) throws TException {
        UserGroupInformation clientUgi = null;
        try {
            clientUgi = this.shim.createRemoteUser(SessionManager.getUserName(), new ArrayList<String>());
            return this.shim.doAs(clientUgi, new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        return HttpCLIServiceUGIProcessor.this.underlyingProcessor.process(in, out);
                    }
                    catch (TException te) {
                        throw new RuntimeException(te);
                    }
                }
            });
        }
        catch (RuntimeException rte) {
            if (rte.getCause() instanceof TException) {
                throw (TException)rte.getCause();
            }
            throw rte;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

