/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.auth;

import io.trino.hive.jdbc.;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.shims.ShimLoader;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.TSubjectAssumingTransport;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.ThriftCLIService;
import io.trino.hive.jdbc.$internal.org.apache.thrift.TProcessor;
import io.trino.hive.jdbc.$internal.org.apache.thrift.TProcessorFactory;
import io.trino.hive.jdbc.$internal.org.apache.thrift.transport.TSaslClientTransport;
import io.trino.hive.jdbc.$internal.org.apache.thrift.transport.TTransport;
import java.io.IOException;
import java.util.Map;
import javax.security.sasl.SaslException;

public class KerberosSaslHelper {
    public static TProcessorFactory getKerberosProcessorFactory(HadoopThriftAuthBridge.Server saslServer, ThriftCLIService service) {
        return new CLIServiceProcessorFactory(saslServer, service);
    }

    public static TTransport getKerberosTransport(String principal, String host, TTransport underlyingTransport, Map<String, String> saslProps, boolean assumeSubject) throws SaslException {
        try {
            String[] names = principal.split("[/@]");
            if (names.length != 3) {
                throw new IllegalArgumentException("Kerberos principal should have 3 parts: " + principal);
            }
            if (assumeSubject) {
                return KerberosSaslHelper.createSubjectAssumedTransport(principal, underlyingTransport, saslProps);
            }
            HadoopThriftAuthBridge.Client authBridge = ShimLoader.getHadoopThriftAuthBridge().createClientWithConf("kerberos");
            return authBridge.createClientTransport(principal, host, "KERBEROS", null, underlyingTransport, saslProps);
        }
        catch (IOException e) {
            throw new SaslException("Failed to open client transport", e);
        }
    }

    public static TTransport createSubjectAssumedTransport(String principal, TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
        TSaslClientTransport saslTransport = null;
        String[] names = principal.split("[/@]");
        try {
            saslTransport = new TSaslClientTransport("GSSAPI", null, names[0], names[1], saslProps, null, underlyingTransport);
            return new TSubjectAssumingTransport(saslTransport);
        }
        catch (SaslException se) {
            throw new IOException("Could not instantiate SASL transport", se);
        }
    }

    public static TTransport getTokenTransport(String tokenStr, String host, TTransport underlyingTransport, Map<String, String> saslProps) throws SaslException {
        HadoopThriftAuthBridge.Client authBridge = ShimLoader.getHadoopThriftAuthBridge().createClientWithConf("kerberos");
        try {
            return authBridge.createClientTransport(null, host, "DIGEST", tokenStr, underlyingTransport, saslProps);
        }
        catch (IOException e) {
            throw new SaslException("Failed to open client transport", e);
        }
    }

    private static class CLIServiceProcessorFactory
    extends TProcessorFactory {
        private final ThriftCLIService service;
        private final HadoopThriftAuthBridge.Server saslServer;

        public CLIServiceProcessorFactory(HadoopThriftAuthBridge.Server saslServer, ThriftCLIService service) {
            super(null);
            this.service = service;
            this.saslServer = saslServer;
        }

        @Override
        public TProcessor getProcessor(TTransport trans) {
            .TCLIService.Processor<ThriftCLIService> sqlProcessor = new .TCLIService.Processor<ThriftCLIService>(this.service);
            return this.saslServer.wrapNonAssumingProcessor(sqlProcessor);
        }
    }
}

