/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation;

import io.trino.hive.jdbc.;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.conf.HiveConf;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.HiveSQLException;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.OperationType;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.HiveCommandOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.Operation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.SQLOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.session.HiveSession;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class ExecuteStatementOperation
extends Operation {
    protected String statement = null;
    protected Map<String, String> confOverlay = new HashMap<String, String>();

    public ExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground) {
        super(parentSession, OperationType.EXECUTE_STATEMENT, runInBackground);
        this.statement = statement;
        this.setConfOverlay(confOverlay);
    }

    public String getStatement() {
        return this.statement;
    }

    public static ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runAsync) throws HiveSQLException {
        String[] tokens = statement.trim().split("\\s+");
        .CommandProcessor processor = null;
        try {
            processor = .CommandProcessorFactory.getForHiveCommand((String[])tokens, (HiveConf)parentSession.getHiveConf());
        }
        catch (SQLException e) {
            throw new HiveSQLException(e.getMessage(), e.getSQLState(), e);
        }
        if (processor == null) {
            return new SQLOperation(parentSession, statement, confOverlay, runAsync);
        }
        return new HiveCommandOperation(parentSession, statement, processor, confOverlay);
    }

    protected Map<String, String> getConfOverlay() {
        return this.confOverlay;
    }

    protected void setConfOverlay(Map<String, String> confOverlay) {
        if (confOverlay != null) {
            this.confOverlay = confOverlay;
        }
    }
}

