/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.conf.HiveConf;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.AbstractService;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.FetchOrientation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.HiveSQLException;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.OperationHandle;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.OperationState;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.OperationStatus;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.RowSet;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.TableSchema;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.GetCatalogsOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.GetColumnsOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.GetFunctionsOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.GetSchemasOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.GetTableTypesOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.GetTablesOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.MetadataOperation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.operation.Operation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.session.HiveSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OperationManager
extends AbstractService {
    private final Log LOG = LogFactory.getLog(OperationManager.class.getName());
    private HiveConf hiveConf;
    private final Map<OperationHandle, Operation> handleToOperation = new HashMap<OperationHandle, Operation>();

    public OperationManager() {
        super("OperationManager");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    public ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runAsync) throws HiveSQLException {
        ExecuteStatementOperation executeStatementOperation = ExecuteStatementOperation.newExecuteStatementOperation(parentSession, statement, confOverlay, runAsync);
        this.addOperation(executeStatementOperation);
        return executeStatementOperation;
    }

    public GetTypeInfoOperation newGetTypeInfoOperation(HiveSession parentSession) {
        GetTypeInfoOperation operation = new GetTypeInfoOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetCatalogsOperation newGetCatalogsOperation(HiveSession parentSession) {
        GetCatalogsOperation operation = new GetCatalogsOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetSchemasOperation newGetSchemasOperation(HiveSession parentSession, String catalogName, String schemaName) {
        GetSchemasOperation operation = new GetSchemasOperation(parentSession, catalogName, schemaName);
        this.addOperation(operation);
        return operation;
    }

    public MetadataOperation newGetTablesOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, List<String> tableTypes) {
        GetTablesOperation operation = new GetTablesOperation(parentSession, catalogName, schemaName, tableName, tableTypes);
        this.addOperation(operation);
        return operation;
    }

    public GetTableTypesOperation newGetTableTypesOperation(HiveSession parentSession) {
        GetTableTypesOperation operation = new GetTableTypesOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetColumnsOperation newGetColumnsOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, String columnName) {
        GetColumnsOperation operation = new GetColumnsOperation(parentSession, catalogName, schemaName, tableName, columnName);
        this.addOperation(operation);
        return operation;
    }

    public GetFunctionsOperation newGetFunctionsOperation(HiveSession parentSession, String catalogName, String schemaName, String functionName) {
        GetFunctionsOperation operation = new GetFunctionsOperation(parentSession, catalogName, schemaName, functionName);
        this.addOperation(operation);
        return operation;
    }

    public synchronized Operation getOperation(OperationHandle operationHandle) throws HiveSQLException {
        Operation operation = this.handleToOperation.get(operationHandle);
        if (operation == null) {
            throw new HiveSQLException("Invalid OperationHandle: " + operationHandle);
        }
        return operation;
    }

    private synchronized void addOperation(Operation operation) {
        this.handleToOperation.put(operation.getHandle(), operation);
    }

    private synchronized Operation removeOperation(OperationHandle opHandle) {
        return this.handleToOperation.remove(opHandle);
    }

    public OperationStatus getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getStatus();
    }

    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.getOperation(opHandle);
        OperationState opState = operation.getStatus().getState();
        if (opState == OperationState.CANCELED || opState == OperationState.CLOSED || opState == OperationState.FINISHED || opState == OperationState.ERROR || opState == OperationState.UNKNOWN) {
            this.LOG.debug(opHandle + ": Operation is already aborted in state - " + (Object)((Object)opState));
        } else {
            this.LOG.debug(opHandle + ": Attempting to cancel from state - " + (Object)((Object)opState));
            operation.cancel();
        }
    }

    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.removeOperation(opHandle);
        if (operation == null) {
            throw new HiveSQLException("Operation does not exist!");
        }
        operation.close();
    }

    public TableSchema getOperationResultSetSchema(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getResultSetSchema();
    }

    public RowSet getOperationNextRowSet(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getNextRowSet();
    }

    public RowSet getOperationNextRowSet(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        return this.getOperation(opHandle).getNextRowSet(orientation, maxRows);
    }
}

